/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Client CLIENT;
    public static final Common COMMON;
    public static final Server SERVER;
    public static ArrayList<String> DEFAULT_WHITELIST;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG);
    }

    static {
        DEFAULT_WHITELIST = new ArrayList();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT = new Client(CLIENT_BUILDER);
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON = new Common(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        SERVER = new Server(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public ForgeConfigSpec.DoubleValue benefitModifier;
        public ForgeConfigSpec.DoubleValue harmfulModifier;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("diet_compat");
            builder.comment("beneficial and harmful diet value modifier when cooked into soup.");
            this.benefitModifier = builder.defineInRange("beneficial_modifier", (double)1.3f, 0.0, 3.4028234663852886E38);
            this.harmfulModifier = builder.defineInRange("harmful_modifier", (double)0.6f, 0.0, 3.4028234663852886E38);
            builder.pop();
        }
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

