/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium;

import com.google.common.collect.ImmutableSet;
import com.teammoeg.thermopolium.Main;
import com.teammoeg.thermopolium.blocks.KitchenStove;
import com.teammoeg.thermopolium.blocks.KitchenStoveT1;
import com.teammoeg.thermopolium.blocks.KitchenStoveT2;
import com.teammoeg.thermopolium.blocks.KitchenStoveTileEntity;
import com.teammoeg.thermopolium.blocks.StewPot;
import com.teammoeg.thermopolium.blocks.StewPotTileEntity;
import com.teammoeg.thermopolium.container.KitchenStoveContainer;
import com.teammoeg.thermopolium.container.StewPotContainer;
import com.teammoeg.thermopolium.data.RecipeSerializer;
import com.teammoeg.thermopolium.data.recipes.BoilingRecipe;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.data.recipes.CookingRecipe;
import com.teammoeg.thermopolium.data.recipes.CountingTags;
import com.teammoeg.thermopolium.data.recipes.DissolveRecipe;
import com.teammoeg.thermopolium.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.thermopolium.data.recipes.FoodValueRecipe;
import com.teammoeg.thermopolium.items.IconItem;
import com.teammoeg.thermopolium.items.StewItem;
import com.teammoeg.thermopolium.items.THPBlockItem;
import com.teammoeg.thermopolium.items.THPItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Contents {
    public static List<Block> registeredBlocks = new ArrayList<Block>();
    public static List<Item> registeredItems = new ArrayList<Item>();
    public static List<Fluid> registeredFluids = new ArrayList<Fluid>();

    public static class THPRecipes {
        public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"thermopolium");

        public static void registerRecipeTypes() {
            CookingRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:stew");
            BoilingRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:boil");
            BowlContainingRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:bowl");
            DissolveRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:dissolve");
            CountingTags.TYPE = IRecipeType.func_222147_a((String)"thermopolium:tags");
            FoodValueRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:food");
            FluidFoodValueRecipe.TYPE = IRecipeType.func_222147_a((String)"thermopolium:fluid_food");
        }

        static {
            CookingRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("cooking", () -> new RecipeSerializer<CookingRecipe>(CookingRecipe::new, CookingRecipe::new, CookingRecipe::write));
            BoilingRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("boiling", () -> new RecipeSerializer<BoilingRecipe>(BoilingRecipe::new, BoilingRecipe::new, BoilingRecipe::write));
            BowlContainingRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("bowl", () -> new RecipeSerializer<BowlContainingRecipe>(BowlContainingRecipe::new, BowlContainingRecipe::new, BowlContainingRecipe::write));
            DissolveRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("dissolve", () -> new RecipeSerializer<DissolveRecipe>(DissolveRecipe::new, DissolveRecipe::new, DissolveRecipe::write));
            CountingTags.SERIALIZER = RECIPE_SERIALIZERS.register("tags", () -> new RecipeSerializer<CountingTags>(CountingTags::new, CountingTags::new, CountingTags::write));
            FoodValueRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("food", () -> new RecipeSerializer<FoodValueRecipe>(FoodValueRecipe::new, FoodValueRecipe::new, FoodValueRecipe::write));
            FluidFoodValueRecipe.SERIALIZER = RECIPE_SERIALIZERS.register("fluid_food", () -> new RecipeSerializer<FluidFoodValueRecipe>(FluidFoodValueRecipe::new, FluidFoodValueRecipe::new, FluidFoodValueRecipe::write));
        }
    }

    public static class THPGui {
        public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"thermopolium");
        public static final RegistryObject<ContainerType<StewPotContainer>> STEWPOT = CONTAINERS.register("stew_pot", () -> IForgeContainerType.create(StewPotContainer::new));
        public static final RegistryObject<ContainerType<KitchenStoveContainer>> STOVE = CONTAINERS.register("kitchen_stove", () -> IForgeContainerType.create(KitchenStoveContainer::new));
    }

    public static class THPTileTypes {
        public static final DeferredRegister<TileEntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"thermopolium");
        public static final RegistryObject<TileEntityType<StewPotTileEntity>> STEW_POT = REGISTER.register("stew_pot", THPTileTypes.makeType(() -> new StewPotTileEntity(), () -> THPBlocks.stew_pot));
        public static final RegistryObject<TileEntityType<KitchenStoveTileEntity>> STOVE1 = REGISTER.register("kitchen_stove_t1", THPTileTypes.makeType(() -> new KitchenStoveT1(), () -> THPBlocks.stove1));
        public static final RegistryObject<TileEntityType<KitchenStoveTileEntity>> STOVE2 = REGISTER.register("kitchen_stove_t2", THPTileTypes.makeType(() -> new KitchenStoveT2(), () -> THPBlocks.stove2));

        private static <T extends TileEntity> Supplier<TileEntityType<T>> makeType(Supplier<T> create, Supplier<Block> valid) {
            return () -> new TileEntityType(create, (Set)ImmutableSet.of(valid.get()), null);
        }
    }

    public static class THPItems {
        public static final String[] items = new String[]{"acquacotta", "bisque", "bone_gelatin", "borscht", "borscht_cream", "congee", "cream_of_meat_soup", "cream_of_mushroom_soup", "custard", "dilute_soup", "egg_drop_soup", "egg_tongsui", "fish_chowder", "fish_soup", "fricassee", "goji_tongsui", "goulash", "gruel", "hodgepodge", "meat_soup", "mushroom_soup", "nail_soup", "nettle_soup", "okroshka", "porridge", "poultry_soup", "pumpkin_soup", "pumpkin_soup_cream", "rice_pudding", "scalded_milk", "seaweed_soup", "stock", "stracciatella", "ukha", "vegetable_chowder", "vegetable_soup", "walnut_soup"};
        public static final List<Item> stews = new ArrayList<Item>();
        public static Item anyWater = new IconItem("water_or_stock_based");
        public static Item stock = new IconItem("stock_based");
        public static Item milk = new IconItem("milk_based");
        public static Item any = new IconItem("any_based");
        public static Item clay_pot = new THPItem("clay_cistern", new Item.Properties().func_200916_a(Main.itemGroup));

        public static void init() {
            for (String s : items) {
                new StewItem(s, new ResourceLocation("thermopolium", s), THPItems.createProps());
            }
            new StewItem("plain_milk", new ResourceLocation("milk"), THPItems.createProps());
            new StewItem("plain_water", new ResourceLocation("water"), THPItems.createProps());
        }

        static Item.Properties createProps() {
            return new Item.Properties().func_200916_a(Main.itemGroup).func_200919_a(Items.field_151054_z).func_200917_a(1);
        }
    }

    public static class THPBlocks {
        public static Block stew_pot = new StewPot("stew_pot", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 10.0f).func_226896_b_(), THPBlockItem::new);
        public static Block stove1 = new KitchenStove("kitchen_stove_t1", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 10.0f).func_226896_b_().func_235838_a_(s -> (Boolean)s.func_177229_b((Property)KitchenStove.LIT) != false ? 7 : 0).func_235828_a_(THPBlocks::isntSolid).func_235842_b_(THPBlocks::isntSolid).func_235847_c_(THPBlocks::isntSolid), THPTileTypes.STOVE1, THPBlockItem::new);
        public static Block stove2 = new KitchenStove("kitchen_stove_t2", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 10.0f).func_226896_b_().func_235838_a_(s -> (Boolean)s.func_177229_b((Property)KitchenStove.LIT) != false ? 9 : 0).func_235828_a_(THPBlocks::isntSolid).func_235842_b_(THPBlocks::isntSolid).func_235847_c_(THPBlocks::isntSolid), THPTileTypes.STOVE2, THPBlockItem::new);

        public static void init() {
        }

        private static boolean isntSolid(BlockState state, IBlockReader reader, BlockPos pos) {
            return false;
        }
    }
}

