/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium;

import com.teammoeg.thermopolium.THPStewTexture;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class THPFluids {
    private static final ResourceLocation STILL_WATER_TEXTURE = new ResourceLocation("block/water_still");
    private static final ResourceLocation STILL_SOUP_TEXTURE = new ResourceLocation("thermopolium", "fluid/soup_fluid");
    private static final ResourceLocation STILL_MILK_TEXTURE = new ResourceLocation("forge", "block/milk_still");
    static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"thermopolium");
    private static final Map<String, TAC> soupfluids = new HashMap<String, TAC>();

    public static TAC soup(int c) {
        return new TAC(STILL_SOUP_TEXTURE, c);
    }

    public static TAC water(int c) {
        return new TAC(STILL_WATER_TEXTURE, c);
    }

    public static TAC milk(int c) {
        return new TAC(STILL_MILK_TEXTURE, c);
    }

    public static Stream<Fluid> getAll() {
        return soupfluids.keySet().stream().map(e -> new ResourceLocation("thermopolium", e)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0));
    }

    public static void init() {
        soupfluids.put("acquacotta", THPFluids.soup(-2313639));
        soupfluids.put("bisque", THPFluids.soup(-4689338));
        soupfluids.put("bone_gelatin", THPFluids.soup(-1859254));
        soupfluids.put("borscht", THPFluids.soup(-8378839));
        soupfluids.put("borscht_cream", THPFluids.soup(-3173490));
        soupfluids.put("congee", THPFluids.soup(-2700365));
        soupfluids.put("cream_of_meat_soup", THPFluids.soup(-4617120));
        soupfluids.put("cream_of_mushroom_soup", THPFluids.soup(-5799585));
        soupfluids.put("custard", THPFluids.soup(-1254802));
        soupfluids.put("dilute_soup", THPFluids.soup(-4016744));
        soupfluids.put("egg_drop_soup", THPFluids.soup(-2508941));
        soupfluids.put("egg_tongsui", THPFluids.soup(-3557243));
        soupfluids.put("fish_chowder", THPFluids.soup(-2636146));
        soupfluids.put("fish_soup", THPFluids.soup(-6192063));
        soupfluids.put("fricassee", THPFluids.soup(-2971553));
        soupfluids.put("goji_tongsui", THPFluids.soup(-5671100));
        soupfluids.put("goulash", THPFluids.soup(-6403542));
        soupfluids.put("gruel", THPFluids.soup(-2901350));
        soupfluids.put("hodgepodge", THPFluids.soup(-4874908));
        soupfluids.put("meat_soup", THPFluids.soup(-7774675));
        soupfluids.put("mushroom_soup", THPFluids.soup(-6855092));
        soupfluids.put("nail_soup", THPFluids.water(-12927489));
        soupfluids.put("nettle_soup", THPFluids.soup(-12158158));
        soupfluids.put("okroshka", THPFluids.soup(-3094666));
        soupfluids.put("porridge", THPFluids.soup(-3755657));
        soupfluids.put("poultry_soup", THPFluids.soup(-4417449));
        soupfluids.put("pumpkin_soup", THPFluids.soup(-2584783));
        soupfluids.put("pumpkin_soup_cream", THPFluids.soup(-1718901));
        soupfluids.put("rice_pudding", THPFluids.soup(-2567492));
        soupfluids.put("scalded_milk", THPFluids.milk(-790301));
        soupfluids.put("seaweed_soup", THPFluids.soup(-11048907));
        soupfluids.put("stock", THPFluids.soup(-4087230));
        soupfluids.put("stracciatella", THPFluids.soup(-4211108));
        soupfluids.put("ukha", THPFluids.soup(-4750029));
        soupfluids.put("vegetable_chowder", THPFluids.soup(-6055358));
        soupfluids.put("vegetable_soup", THPFluids.soup(-8091351));
        soupfluids.put("walnut_soup", THPFluids.soup(-2314126));
        for (Map.Entry<String, TAC> i : soupfluids.entrySet()) {
            FLUIDS.register(i.getKey(), () -> new SoupFluid(new ForgeFlowingFluid.Properties(null, null, SoupFluid.SoupAttributes.builder(THPStewTexture.texture.getOrDefault(i.getKey(), ((TAC)i.getValue()).t), THPStewTexture.texture.getOrDefault(i.getKey(), ((TAC)i.getValue()).t)).viscosity(1200).color(THPStewTexture.texture.containsKey(i.getKey()) ? -1 : ((TAC)i.getValue()).c).temperature(333).rarity(Rarity.UNCOMMON)).slopeFindDistance(1).explosionResistance(100.0f)));
        }
    }

    public static Set<String> getSoupfluids() {
        return soupfluids.keySet();
    }

    private static class TAC {
        ResourceLocation t;
        int c;

        public TAC(ResourceLocation t, int c) {
            this.t = t;
            this.c = c;
        }
    }
}

