/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.api;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import com.teammoeg.thermopolium.items.StewItem;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThermopoliumApi {
    private ThermopoliumApi() {
    }

    public static SoupInfo getInfo(ItemStack item) {
        return StewItem.getInfo(item);
    }

    public static SoupInfo getInfo(FluidStack item) {
        return SoupFluid.getInfo(item);
    }

    public static SoupInfo getInfo(CompoundNBT nbt) {
        return new SoupInfo(nbt);
    }

    public static void setInfo(ItemStack item, SoupInfo info) {
        StewItem.setInfo(item, info);
    }

    public static void setInfo(FluidStack item, SoupInfo info) {
        SoupFluid.setInfo(item, info);
    }

    public static void setInfo(CompoundNBT nbt, SoupInfo info) {
        info.write(nbt);
    }

    public static void applyStew(World worldIn, LivingEntity entityLiving, SoupInfo info) {
        if (!worldIn.field_72995_K) {
            for (EffectInstance effectInstance : info.effects) {
                if (effectInstance == null) continue;
                entityLiving.func_195064_c(effectInstance);
            }
            Random r = entityLiving.func_70681_au();
            for (Pair<EffectInstance, Float> pair : info.foodeffect) {
                if (!(r.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                entityLiving.func_195064_c((EffectInstance)pair.getFirst());
            }
            if (entityLiving instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)entityLiving;
                if (!Float.isNaN(info.saturation)) {
                    playerEntity.func_71024_bL().func_75122_a(info.healing, info.saturation);
                }
            }
        }
    }

    public static Optional<ItemStack> fillBowl(IFluidHandler handler) {
        FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (stack.getAmount() == 250) {
            return ThermopoliumApi.fillBowl(handler.drain(stack, IFluidHandler.FluidAction.EXECUTE));
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> fillBowl(FluidStack stack) {
        if (stack.getAmount() != 250) {
            return Optional.empty();
        }
        BowlContainingRecipe recipe = BowlContainingRecipe.recipes.get(stack.getFluid());
        if (recipe != null) {
            ItemStack ret = recipe.handle(stack);
            return Optional.of(ret);
        }
        return Optional.empty();
    }
}

