/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.api;

import com.teammoeg.thermopolium.fluid.SoupFluid;
import com.teammoeg.thermopolium.items.StewItem;
import com.teammoeg.thermopolium.util.FloatemStack;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ThermopoliumHooks {
    public static final ResourceLocation stew = new ResourceLocation("thermopolium", "stews");

    private ThermopoliumHooks() {
    }

    public static Optional<List<FloatemStack>> getItems(ItemStack stack) {
        IFluidHandlerItem data;
        FluidStack fs;
        if (stack.func_77973_b() instanceof StewItem) {
            return Optional.of(StewItem.getItems(stack));
        }
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent() && (fs = (data = (IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0)).getFluid().getTags().contains(stew)) {
            return Optional.of(SoupFluid.getItems(fs));
        }
        return Optional.empty();
    }

    public static ResourceLocation getBase(ItemStack stack) {
        if (stack.func_77973_b() instanceof StewItem) {
            return StewItem.getBase(stack);
        }
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            return SoupFluid.getBase(data.getFluidInTank(0));
        }
        return new ResourceLocation("water");
    }

    public static SoupInfo getInfo(ItemStack stack) {
        if (stack.func_77973_b() instanceof StewItem) {
            return StewItem.getInfo(stack);
        }
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            return SoupFluid.getInfo(data.getFluidInTank(0));
        }
        return null;
    }
}

