/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.blocks;

import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.Main;
import com.teammoeg.thermopolium.blocks.KitchenStoveTileEntity;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.NetworkHooks;

public class KitchenStove
extends Block {
    public final String name;
    protected int lightOpacity;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty ASH = BooleanProperty.func_177716_a((String)"ash");
    public static final IntegerProperty FUELED = IntegerProperty.func_177719_a((String)"fueled", (int)0, (int)2);
    private final RegistryObject<TileEntityType<KitchenStoveTileEntity>> te;
    static final VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0))));

    public KitchenStove(String name, AbstractBlock.Properties blockProps, RegistryObject<TileEntityType<KitchenStoveTileEntity>> ste, BiFunction<Block, Item.Properties, Item> createItemBlock) {
        super(blockProps);
        this.name = name;
        this.lightOpacity = 15;
        this.te = ste;
        ResourceLocation registryName = this.createRegistryName();
        this.setRegistryName(registryName);
        Contents.registeredBlocks.add(this);
        Item item = createItemBlock.apply(this, new Item.Properties().func_200916_a(Main.itemGroup));
        if (item != null) {
            item.setRegistryName(registryName);
            Contents.registeredItems.add(item);
        }
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ActionResultType p = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        if (p.func_226246_a_()) {
            return p;
        }
        KitchenStoveTileEntity tileEntity = (KitchenStoveTileEntity)worldIn.func_175625_s(pos);
        if (handIn == Hand.MAIN_HAND) {
            if (tileEntity != null && !worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)tileEntity.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return p;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos bp, Random rand) {
        TileEntity te = worldIn.func_175625_s(bp);
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = bp.func_177958_n();
            double d1 = bp.func_177956_o();
            double d2 = bp.func_177952_p();
            if (rand.nextDouble() < 0.2) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + rand.nextDouble(), (double)(bp.func_177956_o() + 1), d2 + rand.nextDouble(), 0.0, 0.0, 0.0);
            if (rand.nextDouble() < 0.5) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.5, (double)(bp.func_177956_o() + 1), d2 + 0.5, rand.nextDouble() * 0.5 - 0.25, rand.nextDouble() * 0.125, rand.nextDouble() * 0.5 - 0.25);
            }
        }
    }

    public ResourceLocation createRegistryName() {
        return new ResourceLocation("thermopolium", this.name);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)this.te.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        KitchenStoveTileEntity te;
        ItemStack is;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof KitchenStoveTileEntity && state.func_177230_c() != newState.func_177230_c() && !(is = (te = (KitchenStoveTileEntity)tileEntity).func_70301_a(0)).func_190926_b()) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING}).func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{FUELED}).func_206894_a(new Property[]{ASH});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ASH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FUELED, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }
}

