/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.blocks;

import com.teammoeg.thermopolium.blocks.AbstractStove;
import com.teammoeg.thermopolium.blocks.KitchenStove;
import com.teammoeg.thermopolium.container.KitchenStoveContainer;
import com.teammoeg.thermopolium.network.INetworkTile;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;

public class KitchenStoveTileEntity
extends INetworkTile
implements IInventory,
ITickableTileEntity,
INamedContainerProvider,
AbstractStove {
    private NonNullList<ItemStack> fuel = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public int process;
    public int processMax;
    private final int speed;
    private final int maxcd;
    private int cd;

    public KitchenStoveTileEntity(TileEntityType<KitchenStoveTileEntity> tet, int spd) {
        super(tet);
        this.speed = spd;
        this.maxcd = 100 / this.speed;
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean isClient) {
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        this.fuel.set(0, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("fuel")));
        if (!isClient) {
            this.cd = nbt.func_74762_e("cd");
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean isClient) {
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        nbt.func_218657_a("fuel", (INBT)((ItemStack)this.fuel.get(0)).serializeNBT());
        if (!isClient) {
            nbt.func_74768_a("cd", this.cd);
        }
    }

    public void func_174888_l() {
        this.fuel.clear();
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return ((ItemStack)this.fuel.get(0)).func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.fuel, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.fuel, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.fuel.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.fuel.get(0);
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0 || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public Container createMenu(int a, PlayerInventory b, PlayerEntity c) {
        return new KitchenStoveContainer(a, b, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.thermopolium.kitchen_stove.title");
    }

    private boolean consumeFuel() {
        int time = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.fuel.get(0)), (IRecipeType)IRecipeType.field_222150_b);
        if (time <= 0) {
            this.processMax = 0;
            this.process = 0;
            return false;
        }
        ((ItemStack)this.fuel.get(0)).func_190918_g(1);
        float ftime = (float)time * 1.0f / (float)this.speed;
        float frac = MathHelper.func_226164_h_((float)ftime);
        this.processMax = frac > 0.0f ? (this.process = (int)ftime + (this.field_145850_b.field_73012_v.nextDouble() < (double)frac ? 1 : 0)) : (this.process = (int)ftime);
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int fs;
            boolean ie;
            BlockState bs = this.func_195044_w();
            boolean flag = false;
            boolean requireSync = false;
            if (this.process <= 0 && (((Boolean)bs.func_177229_b((Property)KitchenStove.LIT)).booleanValue() || ((Boolean)bs.func_177229_b((Property)KitchenStove.ASH)).booleanValue())) {
                bs = (BlockState)((BlockState)bs.func_206870_a((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(false));
                flag = true;
            }
            if ((ie = ((ItemStack)this.fuel.get(0)).func_190926_b()) != ((fs = ((Integer)bs.func_177229_b((Property)KitchenStove.FUELED)).intValue()) == 0)) {
                flag = true;
                bs = (BlockState)bs.func_206870_a((Property)KitchenStove.FUELED, (Comparable)Integer.valueOf(ie ? 0 : 1));
            }
            if (this.process > 0) {
                if (!((Boolean)bs.func_177229_b((Property)KitchenStove.ASH)).booleanValue()) {
                    flag = true;
                    bs = (BlockState)bs.func_206870_a((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(true));
                }
                if (((Boolean)bs.func_177229_b((Property)KitchenStove.LIT)).booleanValue()) {
                    --this.cd;
                    --this.process;
                    requireSync = true;
                    if (this.cd <= 0) {
                        bs = (BlockState)bs.func_206870_a((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false));
                        flag = true;
                    }
                }
            }
            if (flag) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), bs);
            }
            if (requireSync) {
                this.syncData();
            }
        }
    }

    @Override
    public int requestHeat() {
        if (this.process <= 0) {
            if (!this.consumeFuel()) {
                return 0;
            }
            --this.process;
        }
        BlockState bs = this.func_195044_w();
        this.cd = this.maxcd;
        if (!((Boolean)bs.func_177229_b((Property)KitchenStove.LIT)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)bs.func_206870_a((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(true)));
        }
        return this.speed;
    }

    @Override
    public boolean canEmitHeat() {
        return this.process > 0 || ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.fuel.get(0)), (IRecipeType)IRecipeType.field_222150_b) > 0;
    }
}

