/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.blocks;

import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.Main;
import com.teammoeg.thermopolium.blocks.StewPotTileEntity;
import com.teammoeg.thermopolium.client.Particles;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.items.StewItem;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class StewPot
extends Block {
    public final String name;
    protected int lightOpacity;
    public static final EnumProperty<Direction.Axis> FACING = BlockStateProperties.field_208199_z;
    static final VoxelShape shape = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public StewPot(String name, AbstractBlock.Properties blockProps, BiFunction<Block, Item.Properties, Item> createItemBlock) {
        super(blockProps.func_208770_d());
        this.name = name;
        this.lightOpacity = 15;
        ResourceLocation registryName = this.createRegistryName();
        this.setRegistryName(registryName);
        Contents.registeredBlocks.add(this);
        Item item = createItemBlock.apply(this, new Item.Properties().func_200916_a(Main.itemGroup));
        if (item != null) {
            item.setRegistryName(registryName);
            Contents.registeredItems.add(item);
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ActionResultType p = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        if (p.func_226246_a_()) {
            return p;
        }
        StewPotTileEntity tileEntity = (StewPotTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity.canAddFluid()) {
            ItemStack held = player.func_184586_b(handIn);
            if (held.func_190926_b() && player.func_225608_bj_()) {
                tileEntity.getTank().setFluid(FluidStack.EMPTY);
                tileEntity.current = null;
                return ActionResultType.SUCCESS;
            }
            if (held.func_77973_b() instanceof StewItem) {
                if (tileEntity.tryAddFluid(BowlContainingRecipe.extractFluid(held))) {
                    ItemStack ret = held.getContainerItem();
                    held.func_190918_g(1);
                    if (!player.func_191521_c(ret)) {
                        player.func_71019_a(ret, false);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)tileEntity.getTank())) {
                tileEntity.syncData();
                return ActionResultType.SUCCESS;
            }
        }
        if (handIn == Hand.MAIN_HAND) {
            if (tileEntity != null && !worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)tileEntity.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return p;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StewPotTileEntity) {
            StewPotTileEntity pot = (StewPotTileEntity)te;
            if (pot.proctype == 2 && pot.working) {
                double d0 = pos.func_177958_n();
                double d1 = pos.func_177956_o() + 1;
                double d2 = pos.func_177952_p();
                int count = 2;
                while (--count != 0) {
                    worldIn.func_195594_a((IParticleData)Particles.STEAM.get(), d0 + (double)rand.nextFloat(), d1, d2 + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public ResourceLocation createRegistryName() {
        return new ResourceLocation("thermopolium", this.name);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new StewPotTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof StewPotTileEntity && state.func_177230_c() != newState.func_177230_c()) {
            StewPotTileEntity te = (StewPotTileEntity)tileEntity;
            if (te.proctype != 2) {
                for (int i = 0; i < 11; ++i) {
                    ItemStack is = te.getInv().getStackInSlot(i);
                    if (is.func_190926_b()) continue;
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
                }
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        StewPotTileEntity te;
        TileEntity tileEntity;
        float f;
        if (worldIn.field_73012_v.nextInt(25) == 1 && !((f = worldIn.func_226691_t_(pos).func_225486_c(pos)) < 0.15f) && (tileEntity = worldIn.func_175625_s(pos)) instanceof StewPotTileEntity && (te = (StewPotTileEntity)tileEntity).canAddFluid()) {
            te.tryAddFluid(new FluidStack((Fluid)Fluids.field_204546_a, 250));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f().func_176740_k());
    }
}

