/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.blocks;

import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.Main;
import com.teammoeg.thermopolium.blocks.AbstractStove;
import com.teammoeg.thermopolium.container.StewPotContainer;
import com.teammoeg.thermopolium.data.recipes.BoilingRecipe;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.data.recipes.CookingRecipe;
import com.teammoeg.thermopolium.data.recipes.DissolveRecipe;
import com.teammoeg.thermopolium.data.recipes.FoodValueRecipe;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import com.teammoeg.thermopolium.items.StewItem;
import com.teammoeg.thermopolium.network.INetworkTile;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class StewPotTileEntity
extends INetworkTile
implements ITickableTileEntity,
INamedContainerProvider {
    private ItemStackHandler inv = new ItemStackHandler(11){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 9) {
                return stack.func_77973_b() == Items.field_151068_bn && !PotionUtils.func_185189_a((ItemStack)stack).stream().anyMatch(t -> t.field_76460_b == 1) || CookingRecipe.isCookable(stack);
            }
            if (slot == 9) {
                Item i = stack.func_77973_b();
                return i == Items.field_151054_z || i instanceof StewItem;
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot < 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    public SoupInfo current;
    private FluidTank tank = new FluidTank(1250, CookingRecipe::isBoilable){

        protected void onContentsChanged() {
            if (this.isEmpty()) {
                StewPotTileEntity.this.current = null;
            }
        }
    };
    public int process;
    public int processMax;
    public boolean working = false;
    public boolean operate = false;
    public short proctype = 0;
    public boolean rsstate = false;
    public Fluid become;
    public ResourceLocation nextbase;
    public static final short NOP = 0;
    public static final short BOILING = 1;
    public static final short COOKING = 2;
    public static final short STIRING = 3;
    IFluidHandler handler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int t) {
            if (t == 0) {
                return StewPotTileEntity.this.tank.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int t) {
            if (t == 0) {
                return StewPotTileEntity.this.tank.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int t, FluidStack stack) {
            if (t == 0 && StewPotTileEntity.this.canAddFluid()) {
                return StewPotTileEntity.this.tank.isFluidValid(stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotTileEntity.this.canAddFluid()) {
                int filled = StewPotTileEntity.this.tank.fill(resource, action);
                if (filled > 0 && action.execute()) {
                    StewPotTileEntity.this.syncData();
                }
                return filled;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotTileEntity.this.canAddFluid()) {
                FluidStack drained = StewPotTileEntity.this.tank.drain(resource, action);
                if (!drained.isEmpty() && action.execute()) {
                    StewPotTileEntity.this.syncData();
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (StewPotTileEntity.this.canAddFluid()) {
                FluidStack drained = StewPotTileEntity.this.tank.drain(maxDrain, action);
                if (!drained.isEmpty() && action.execute()) {
                    StewPotTileEntity.this.syncData();
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }
    };
    RangedWrapper bowl = new RangedWrapper((IItemHandlerModifiable)this.inv, 9, 11){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 10) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 9) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    RangedWrapper ingredient = new RangedWrapper((IItemHandlerModifiable)this.inv, 0, 9){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };
    LazyOptional<IItemHandler> up = LazyOptional.of(() -> this.ingredient);
    LazyOptional<IItemHandler> side = LazyOptional.of(() -> this.bowl);
    LazyOptional<IFluidHandler> fl = LazyOptional.of(() -> this.handler);

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public StewPotTileEntity() {
        super((TileEntityType)Contents.THPTileTypes.STEW_POT.get());
    }

    public FluidTank getTank() {
        return this.tank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_73660_a() {
        boolean flag = false;
        if (this.field_145850_b.field_72995_K) return;
        this.working = false;
        if (this.processMax > 0) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (!(te instanceof AbstractStove)) return;
            int rh = ((AbstractStove)te).requestHeat();
            this.process += rh;
            if (rh > 0) {
                this.working = true;
                flag = true;
            }
            if (this.process >= this.processMax) {
                this.process = 0;
                this.processMax = 0;
                this.doWork();
                flag = true;
            }
        } else {
            this.prepareWork();
            if (this.canAddFluid()) {
                flag |= this.tryContianFluid();
            }
        }
        if (!flag) return;
        this.syncData();
    }

    private boolean tryContianFluid() {
        ItemStack is = this.inv.getStackInSlot(9);
        if (!is.func_190926_b() && this.inv.getStackInSlot(10).func_190926_b()) {
            BowlContainingRecipe recipe;
            if (is.func_77973_b() == Items.field_151054_z && this.tank.getFluidAmount() >= 250 && (recipe = BowlContainingRecipe.recipes.get(this.tank.getFluid().getFluid())) != null) {
                is.func_190918_g(1);
                this.inv.setStackInSlot(10, recipe.handle(this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE)));
                return true;
            }
            if (is.func_77973_b() instanceof StewItem) {
                if (this.tryAddFluid(BowlContainingRecipe.extractFluid(is))) {
                    ItemStack ret = is.getContainerItem();
                    is.func_190918_g(1);
                    this.inv.setStackInSlot(10, ret);
                    return true;
                }
                return false;
            }
            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true);
            if (far.isSuccess()) {
                is.func_190918_g(1);
                if (far.getResult() != null) {
                    this.inv.setStackInSlot(10, far.getResult());
                }
                return true;
            }
        }
        return false;
    }

    public boolean canAddFluid() {
        return this.proctype == 0;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean isClient) {
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        this.proctype = nbt.func_74765_d("worktype");
        this.rsstate = nbt.func_74767_n("rsstate");
        this.inv.deserializeNBT(nbt.func_74775_l("inv"));
        if (isClient) {
            this.working = nbt.func_74767_n("working");
        }
        this.tank.readFromNBT(nbt);
        this.become = nbt.func_74764_b("result") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i("result"))) : null;
        if (!isClient) {
            this.current = nbt.func_74764_b("current") ? new SoupInfo(nbt.func_74775_l("current")) : null;
            this.nextbase = nbt.func_74764_b("resultBase") ? new ResourceLocation(nbt.func_74779_i("resultBase")) : null;
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean isClient) {
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        nbt.func_74777_a("worktype", this.proctype);
        nbt.func_74757_a("rsstate", this.rsstate);
        if (isClient) {
            nbt.func_74757_a("working", this.working);
        }
        nbt.func_218657_a("inv", (INBT)this.inv.serializeNBT());
        this.tank.writeToNBT(nbt);
        if (this.become != null) {
            nbt.func_74778_a("result", this.become.getRegistryName().toString());
        }
        if (!isClient) {
            if (this.current != null) {
                nbt.func_218657_a("current", (INBT)this.current.save());
            }
            if (this.nextbase != null) {
                nbt.func_74778_a("resultBase", this.nextbase.toString());
            }
        }
    }

    private void prepareWork() {
        if (this.rsstate && this.proctype == 0 && !this.operate && this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.operate = true;
        }
        if (this.proctype == 0) {
            if (this.operate) {
                this.operate = false;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (!(te instanceof AbstractStove) || !((AbstractStove)te).canEmitHeat()) {
                    return;
                }
                if (this.doBoil()) {
                    this.proctype = 1;
                } else if (this.makeSoup()) {
                    this.proctype = (short)2;
                }
            }
        } else if (this.proctype == 1) {
            this.proctype = this.makeSoup() ? (short)2 : (short)0;
        } else {
            Main.logger.warn("Unproper process in stew pot " + this.serializeNBT() + " forced to proper");
            this.processMax = 50;
        }
    }

    private void doWork() {
        if (this.proctype == 1) {
            this.finishBoil();
            boolean hasItem = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack is = this.inv.getStackInSlot(i);
                if (is.func_190926_b()) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) {
                this.proctype = 0;
            }
        } else if (this.proctype == 2 || this.proctype == 3) {
            this.finishSoup();
        }
    }

    private boolean doBoil() {
        BoilingRecipe recipe = BoilingRecipe.recipes.get(this.tank.getFluid().getFluid());
        if (recipe == null) {
            return false;
        }
        this.become = recipe.after;
        this.processMax = (int)((float)recipe.time * ((float)this.tank.getFluidAmount() / 250.0f));
        this.process = 0;
        return true;
    }

    private void finishBoil() {
        BoilingRecipe recipe = BoilingRecipe.recipes.get(this.tank.getFluid().getFluid());
        if (recipe == null) {
            return;
        }
        this.current = null;
        this.tank.setFluid(recipe.handle(this.tank.getFluid()));
    }

    private void adjustParts(int count) {
        float oparts = (float)this.tank.getFluidAmount() / 250.0f;
        int parts = (int)(oparts + (float)count);
        this.getCurrent().adjustParts(oparts, parts);
        this.tank.getFluid().setAmount(parts * 250);
    }

    private boolean makeSoup() {
        if (this.tank.getFluidAmount() <= 250) {
            return false;
        }
        if (this.getCurrent().stacks.size() > 27) {
            return false;
        }
        int oparts = this.tank.getFluidAmount() / 250;
        int parts = oparts - 1;
        int itms = 0;
        ArrayList<EffectInstance> cr = new ArrayList<EffectInstance>(this.current.effects);
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.inv.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            if (is.func_77973_b() == Items.field_151068_bn) {
                block1: for (EffectInstance n : PotionUtils.func_185189_a((ItemStack)is)) {
                    for (EffectInstance eff : cr) {
                        if (!SoupInfo.isEffectEquals(eff, n)) continue;
                        continue block1;
                    }
                    cr.add(n);
                }
                continue;
            }
            if (CookingRecipe.isCookable(is)) {
                ++itms;
                continue;
            }
            return false;
        }
        if ((float)itms / (float)parts + this.current.getDensity() * (float)oparts / (float)parts > 3.0f || cr.size() > 3) {
            return false;
        }
        this.process = 0;
        this.adjustParts(-1);
        boolean hasItem = false;
        NonNullList interninv = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.inv.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            if (is.func_77973_b() == Items.field_151068_bn) {
                for (EffectInstance eff : PotionUtils.func_185189_a((ItemStack)is)) {
                    this.current.addEffect(eff, parts);
                }
                this.inv.setStackInSlot(i, new ItemStack((IItemProvider)Items.field_151069_bo));
            } else {
                for (int j = 0; j < 9; ++j) {
                    ItemStack ois = (ItemStack)interninv.get(j);
                    if (ois.func_190926_b()) {
                        interninv.set(j, (Object)is.func_77946_l());
                        break;
                    }
                    if (!ois.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)ois, (ItemStack)is)) continue;
                    ois.func_190920_e(ois.func_190916_E() + is.func_190916_E());
                    break;
                }
                this.inv.setStackInSlot(i, is.getContainerItem());
            }
            hasItem = true;
        }
        if (!hasItem) {
            this.current.completeEffects();
            this.processMax = Math.max(100, this.decideSoup());
            return true;
        }
        int[] iis = new int[9];
        int imax = 9;
        block6: for (int i = 0; i < 9; ++i) {
            ItemStack is = (ItemStack)interninv.get(i);
            if (is.func_190926_b()) {
                imax = i;
                break;
            }
            for (DissolveRecipe rs : DissolveRecipe.recipes) {
                if (!rs.item.test(is)) continue;
                iis[i] = rs.time;
                continue block6;
            }
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(is.func_77973_b());
            if (fvr == null) continue;
            iis[i] = fvr.processtimes.getOrDefault(is.func_77973_b(), 0);
        }
        int tpt = 50;
        for (int i = 0; i < imax; ++i) {
            ItemStack is = (ItemStack)interninv.get(i);
            if (!is.func_190926_b()) {
                for (DissolveRecipe rs : DissolveRecipe.recipes) {
                    if (!rs.item.test(is)) continue;
                    int n = i;
                    iis[n] = iis[n] + rs.time;
                    break;
                }
                this.current.addItem(is, parts);
            }
            tpt += iis[i];
        }
        this.current.completeAll();
        tpt = Math.max(100, tpt);
        interninv.clear();
        this.processMax = Math.max(this.decideSoup(), tpt);
        return true;
    }

    private int decideSoup() {
        this.become = this.tank.getFluid().getFluid();
        StewPendingContext ctx = new StewPendingContext(this.getCurrent(), this.become.getRegistryName());
        this.nextbase = this.current.base;
        if (ctx.getItems().isEmpty()) {
            return 0;
        }
        CookingRecipe cri = CookingRecipe.recipes.get(this.become);
        if (cri == null || cri.getPriority() < 0 || cri.matches(ctx) == 0) {
            for (CookingRecipe cr : CookingRecipe.sorted) {
                int mt = cr.matches(ctx);
                if (mt == 0) continue;
                this.nextbase = mt == 2 ? this.become.getRegistryName() : this.current.base;
                this.become = cr.output;
                return cr.time;
            }
        }
        return 0;
    }

    private void finishSoup() {
        if (this.nextbase != null && this.become != null) {
            this.getCurrent().base = this.nextbase;
            this.nextbase = null;
            FluidStack fss = new FluidStack(this.become, this.tank.getFluidAmount());
            this.current.recalculateHAS();
            SoupFluid.setInfo(fss, this.current);
            this.current = null;
            this.tank.setFluid(fss);
        }
        this.become = null;
        this.nextbase = null;
        this.proctype = 0;
    }

    public boolean canAddFluid(FluidStack fs) {
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            return tryfill == fs.getAmount();
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (!(te instanceof AbstractStove) || !((AbstractStove)te).canEmitHeat()) {
            return false;
        }
        SoupInfo n = SoupFluid.getInfo(fs);
        if (!this.getCurrent().base.equals((Object)n.base)) {
            BoilingRecipe bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (!this.current.base.equals((Object)bnx.after.getRegistryName())) {
                return false;
            }
        }
        return this.current.canMerge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f);
    }

    public boolean tryAddFluid(FluidStack fs) {
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            if (tryfill == fs.getAmount()) {
                this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            return false;
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (!(te instanceof AbstractStove) || !((AbstractStove)te).canEmitHeat()) {
            return false;
        }
        SoupInfo n = SoupFluid.getInfo(fs);
        int pm = 0;
        if (!(this.getCurrent().base.equals((Object)n.base) || this.current.base.equals((Object)fs.getFluid().getRegistryName()) || n.base.equals((Object)this.tank.getFluid().getFluid().getRegistryName()))) {
            BoilingRecipe bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (!this.getCurrent().base.equals((Object)bnx.after.getRegistryName())) {
                return false;
            }
            fs = bnx.handle(fs);
            pm = (int)((float)bnx.time * ((float)fs.getAmount() / 250.0f));
        }
        if (this.current.merge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f)) {
            this.adjustParts(fs.getAmount() / 250);
            int num = Math.max(this.decideSoup(), 50);
            this.proctype = (short)3;
            this.process = 0;
            this.processMax = Math.max(pm, num);
            return true;
        }
        return false;
    }

    public Container createMenu(int p1, PlayerInventory p2, PlayerEntity p3) {
        return new StewPotContainer(p1, p2, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.thermopolium.stewpot.title");
    }

    @Override
    public void handleMessage(short type, int data) {
        if (type == 0 && this.proctype == 0) {
            this.operate = true;
        }
        if (type == 1) {
            if (data == 1) {
                this.rsstate = false;
            } else if (data == 2) {
                this.rsstate = true;
            }
            this.syncData();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.up.cast();
            }
            return this.side.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fl.cast();
        }
        return super.getCapability(cap, side);
    }

    public SoupInfo getCurrent() {
        if (this.current == null) {
            this.current = SoupFluid.getInfo(this.tank.getFluid());
        }
        return this.current;
    }
}

