/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class RenderUtils {
    private RenderUtils() {
    }

    public static void handleGuiTank(MatrixStack transform, IFluidTank tank, int x, int y, int w, int h) {
        FluidStack fluid = tank.getFluid();
        transform.func_227860_a_();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (fluid != null && fluid.getFluid() != null) {
            int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)tank.getCapacity()));
            RenderUtils.drawRepeatedFluidSpriteGui(buffer, transform, fluid, x, y + h - fluidHeight, w, fluidHeight);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        buffer.func_228461_a_();
        transform.func_227865_b_();
    }

    private static RenderType getGui(ResourceLocation texture) {
        return RenderType.func_228632_a_((String)("gui_" + texture), (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228713_a_(new RenderState.AlphaState(0.5f)).func_228728_a_(false));
    }

    private static void buildVertex(IVertexBuilder bu, MatrixStack transform, float r, float g, float b, float a, float p1, float p2, float u0, float u1, int light, int overlay) {
        bu.func_227888_a_(transform.func_227866_c_().func_227870_a_(), p1, p2, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(u0, u1).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(transform.func_227866_c_().func_227872_b_(), 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    public static void drawRepeatedFluidSpriteGui(IRenderTypeBuffer.Impl buffer, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = RenderUtils.getGui(PlayerContainer.field_226615_c_);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.func_94211_a();
        int iH = sprite.func_94216_b();
        if (iW > 0 && iH > 0) {
            RenderUtils.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 0.8f, LightTexture.func_228451_a_((int)15, (int)15), OverlayTexture.field_229196_a_);
        }
        buffer.func_228462_a_(renderType);
    }

    public static void drawRepeatedSprite(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha, int light, int overlay) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                RenderUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax, light, overlay);
            }
            RenderUtils.drawTexturedColoredRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                RenderUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax, light, overlay);
            }
            RenderUtils.drawTexturedColoredRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf, light, overlay);
        }
    }

    public static void drawTexturedColoredRect(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1, int light, int overlay) {
        RenderUtils.buildVertex(builder, transform, r, g, b, alpha, x, y + h, u0, v1, light, overlay);
        RenderUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y + h, u1, v1, light, overlay);
        RenderUtils.buildVertex(builder, transform, r, g, b, alpha, x + w, y, u1, v0, light, overlay);
        RenderUtils.buildVertex(builder, transform, r, g, b, alpha, x, y, u0, v0, light, overlay);
    }
}

