/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.blocks.StewPotTileEntity;
import com.teammoeg.thermopolium.client.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidStack;

public class StewPotRenderer
extends TileEntityRenderer<StewPotTileEntity> {
    TextureAtlasSprite last;
    Fluid lastf;

    public StewPotRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private static Vector3f clr(int fromcol, int tocol, float proc) {
        float fcolr = (float)(fromcol >> 16 & 0xFF) / 255.0f;
        float fcolg = (float)(fromcol >> 8 & 0xFF) / 255.0f;
        float fcolb = (float)(fromcol & 0xFF) / 255.0f;
        float tcolr = (float)(tocol >> 16 & 0xFF) / 255.0f;
        float tcolg = (float)(tocol >> 8 & 0xFF) / 255.0f;
        float tcolb = (float)(tocol & 0xFF) / 255.0f;
        return new Vector3f(fcolr + (tcolr - fcolr) * proc, fcolg + (tcolg - fcolg) * proc, fcolb + (tcolb - fcolb) * proc);
    }

    private static Vector3f clr(int col) {
        return new Vector3f((float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f);
    }

    public void render(StewPotTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!te.func_145831_w().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockState state = te.func_195044_w();
        if (state.func_177230_c() != Contents.THPBlocks.stew_pot) {
            return;
        }
        FluidStack fs = te.getTank().getFluid();
        if (fs != null && !fs.isEmpty() && fs.getFluid() != null) {
            matrixStack.func_227860_a_();
            float rr = fs.getAmount();
            if (te.proctype == 2) {
                rr += 250.0f * (1.0f - (float)te.process * 1.0f / (float)te.processMax);
            }
            float yy = Math.min(1.0f, rr / (float)te.getTank().getCapacity()) * 0.5f + 0.3125f;
            matrixStack.func_227861_a_(0.0, (double)yy, 0.0);
            matrixStack.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228645_f_());
            if (this.lastf != fs.getFluid()) {
                this.last = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(fs.getFluid().getAttributes().getStillTexture(fs));
                this.lastf = fs.getFluid();
            }
            int col = fs.getFluid().getAttributes().getColor(fs);
            int iW = this.last.func_94211_a();
            int iH = this.last.func_94216_b();
            if (iW > 0 && iH > 0) {
                Vector3f clr;
                float alp = 1.0f;
                if (te.become != null && te.processMax > 0) {
                    TextureAtlasSprite sprite2 = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(te.become.getFluid().getAttributes().getStillTexture(fs));
                    float proc = (float)te.process * 1.0f / (float)te.processMax;
                    clr = StewPotRenderer.clr(col, te.become.getAttributes().getColor(fs), proc);
                    if (sprite2.func_94211_a() > 0 && sprite2.func_94216_b() > 0) {
                        alp = 1.0f - proc;
                        RenderUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.func_195899_a(), clr.func_195900_b(), clr.func_195902_c(), proc, sprite2.func_94209_e(), sprite2.func_94212_f(), sprite2.func_94206_g(), sprite2.func_94210_h(), combinedLightIn, combinedOverlayIn);
                    }
                } else {
                    clr = StewPotRenderer.clr(col);
                }
                RenderUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.func_195899_a(), clr.func_195900_b(), clr.func_195902_c(), alp, this.last.func_94209_e(), this.last.func_94212_f(), this.last.func_94206_g(), this.last.func_94210_h(), combinedLightIn, combinedOverlayIn);
            }
            matrixStack.func_227865_b_();
        }
    }
}

