/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teammoeg.thermopolium.blocks.StewPotTileEntity;
import com.teammoeg.thermopolium.client.RenderUtils;
import com.teammoeg.thermopolium.container.StewPotContainer;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import com.teammoeg.thermopolium.items.StewItem;
import com.teammoeg.thermopolium.util.FloatemStack;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class StewPotScreen
extends ContainerScreen<StewPotContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thermopolium", "textures/gui/cistern_culinary.png");
    StewPotTileEntity te;
    public static TranslationTextComponent start = new TranslationTextComponent("gui.thermopolium.stewpot.canstart");
    public static TranslationTextComponent started = new TranslationTextComponent("gui.thermopolium.stewpot.started");
    public static TranslationTextComponent nostart = new TranslationTextComponent("gui.thermopolium.stewpot.cantstart");
    public static TranslationTextComponent nors = new TranslationTextComponent("gui.thermopolium.stewpot.noredstone");
    public static TranslationTextComponent rs = new TranslationTextComponent("gui.thermopolium.stewpot.redstone");
    private ArrayList<ITextComponent> tooltip = new ArrayList(2);
    ImageButton btn1;
    ImageButton btn2;

    public StewPotScreen(StewPotContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.field_238743_q_ = 4;
        this.field_238742_p_ = 7;
        this.field_238745_s_ = this.field_147000_g - 92;
        this.field_238744_r_ = 4;
        this.te = container.getTile();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.btn1 = new ImageButton(this.field_147003_i + 7, this.field_147009_r + 48, 20, 12, 176, 83, (b, s, x, y) -> {
            if (this.btn1.state == 0) {
                this.tooltip.add((ITextComponent)start);
            } else {
                this.tooltip.add((ITextComponent)started);
            }
        }, btn -> {
            if (this.btn1.state == 0) {
                this.te.sendMessage((short)0, 0);
            }
        });
        this.func_230480_a_((Widget)this.btn1);
        this.btn2 = new ImageButton(this.field_147003_i + 7, this.field_147009_r + 61, 20, 20, 176, 107, (b, s, x, y) -> {
            if (this.btn2.state == 1) {
                this.tooltip.add((ITextComponent)nors);
            } else {
                this.tooltip.add((ITextComponent)rs);
            }
        }, btn -> this.te.sendMessage((short)1, this.btn2.state));
        this.func_230480_a_((Widget)this.btn2);
    }

    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partial) {
        this.tooltip.clear();
        this.btn1.state = this.te.proctype > 0 ? 1 : 0;
        this.btn2.state = this.te.rsstate ? 1 : 2;
        super.func_230430_a_(transform, mouseX, mouseY, partial);
        if (this.te.proctype < 2 && !this.te.getTank().isEmpty()) {
            if (this.isMouseIn(mouseX, mouseY, 105, 20, 16, 46)) {
                this.tooltip.add(this.te.getTank().getFluid().getDisplayName());
                SoupInfo si = SoupFluid.getInfo(this.te.getTank().getFluid());
                FloatemStack fs = si.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
                if (fs != null) {
                    this.tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.thermopolium.main_ingredient", new Object[]{fs.getStack().func_151000_E()}));
                }
                StewItem.addPotionTooltip(si.effects, this.tooltip, 1.0f);
            }
            RenderUtils.handleGuiTank(transform, (IFluidTank)this.te.getTank(), this.field_147003_i + 105, this.field_147009_r + 20, 16, 46);
        }
        if (!this.tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)transform, this.tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        } else {
            super.func_230459_a_(transform, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, -2456213);
        ITextComponent name = this.field_213127_e.func_145748_c_();
        int w = this.field_230712_o_.func_78256_a(name.getString());
        this.field_230712_o_.func_243248_b(matrixStack, name, (float)(this.field_146999_f - w - this.field_238744_r_), (float)this.field_238745_s_, -2456213);
    }

    protected void func_230450_a_(MatrixStack transform, float partial, int x, int y) {
        this.func_230446_a_(transform);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.te.processMax > 0 && this.te.process > 0) {
            int h = (int)(29.0f * ((float)this.te.process / (float)this.te.processMax));
            this.func_238474_b_(transform, this.field_147003_i + 9, this.field_147009_r + 17 + h, 176, 54 + h, 16, 29 - h);
        }
        if (this.te.proctype > 1) {
            if (this.te.proctype == 2) {
                this.func_238474_b_(transform, this.field_147003_i + 44, this.field_147009_r + 16, 176, 0, 54, 54);
            }
            this.func_238474_b_(transform, this.field_147003_i + 102, this.field_147009_r + 17, 230, 0, 21, 51);
        }
    }

    public boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.field_147003_i + x && mouseY >= this.field_147009_r + y && mouseX < this.field_147003_i + x + w && mouseY < this.field_147009_r + y + h;
    }

    public static class ImageButton
    extends Button {
        int xTexStart;
        int yTexStart;
        private final int textureWidth;
        private final int textureHeight;
        int state;

        public ImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, Button.IPressable onPressIn) {
            this(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, field_238486_s_, onPressIn);
        }

        public ImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, Button.ITooltip tt, Button.IPressable onPressIn) {
            this(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, 256, 256, onPressIn, tt, StringTextComponent.field_240750_d_);
        }

        public ImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int textureWidth, int textureHeight, Button.IPressable onPress, ITextComponent title) {
            this(x, y, width, height, xTexStart, yTexStart, textureWidth, textureHeight, onPress, field_238486_s_, title);
        }

        public ImageButton(int p_i244513_1_, int p_i244513_2_, int p_i244513_3_, int p_i244513_4_, int p_i244513_5_, int p_i244513_6_, int p_i244513_9_, int p_i244513_10_, Button.IPressable p_i244513_11_, Button.ITooltip p_i244513_12_, ITextComponent p_i244513_13_) {
            super(p_i244513_1_, p_i244513_2_, p_i244513_3_, p_i244513_4_, p_i244513_13_, p_i244513_11_, p_i244513_12_);
            this.textureWidth = p_i244513_9_;
            this.textureHeight = p_i244513_10_;
            this.xTexStart = p_i244513_5_;
            this.yTexStart = p_i244513_6_;
        }

        public void setPosition(int xIn, int yIn) {
            this.field_230690_l_ = xIn;
            this.field_230691_m_ = yIn;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int i = 0;
            int j = this.state * this.field_230689_k_;
            if (this.func_230449_g_()) {
                i += this.field_230688_j_;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            RenderSystem.enableDepthTest();
            ImageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)(this.xTexStart + i), (float)(this.yTexStart + j), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.textureWidth, (int)this.textureHeight);
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }
    }
}

