/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.data.recipes.BoilingRecipe;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.data.recipes.CookingRecipe;
import com.teammoeg.thermopolium.data.recipes.CountingTags;
import com.teammoeg.thermopolium.data.recipes.DissolveRecipe;
import com.teammoeg.thermopolium.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.thermopolium.data.recipes.FoodValueRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    DataPackRegistries data;
    public static final Logger logger = LogManager.getLogger((String)"Thermopolium recipe generator");
    RecipeManager clientRecipeManager;
    static int generated_fv = 0;

    public RecipeReloadListener(DataPackRegistries dpr) {
        this.data = dpr;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        RecipeReloadListener.buildRecipeLists(this.data.func_240967_e_());
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (FoodValueRecipe.recipeset != null) {
            FoodValueRecipe.recipeset.forEach(FoodValueRecipe::clearCache);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            RecipeReloadListener.buildRecipeLists(event.getRecipeManager());
        }
    }

    private static FoodValueRecipe addCookingTime(Item i, ItemStack iis, List<SmokingRecipe> irs, boolean force) {
        if (FoodValueRecipe.recipes.containsKey(i)) {
            return FoodValueRecipe.recipes.get(i);
        }
        for (SmokingRecipe sr : irs) {
            if (!((Ingredient)sr.func_192400_c().get(0)).test(iis)) continue;
            ItemStack reslt = sr.func_77572_b(null);
            if (DissolveRecipe.recipes.stream().anyMatch(e -> e.test(reslt))) continue;
            FoodValueRecipe ret = RecipeReloadListener.addCookingTime(reslt.func_77973_b(), reslt, irs, true);
            Food of = i.func_219967_s();
            if (of != null && of.func_221466_a() > ret.heal) {
                ret.effects = of.func_221464_f();
                ret.heal = of.func_221466_a();
                ret.sat = of.func_221469_b();
                ret.setRepersent(iis);
            }
            FoodValueRecipe.recipes.put(i, ret);
            ret.processtimes.put(i, sr.func_222137_e() + ret.processtimes.getOrDefault(reslt.func_77973_b(), 0));
            return ret;
        }
        if (force) {
            Food of = i.func_219967_s();
            FoodValueRecipe ret = FoodValueRecipe.recipes.computeIfAbsent(i, e -> new FoodValueRecipe(new ResourceLocation("thermopolium", "food/generated/" + generated_fv++), 0, 0.0f, iis, (Item)e));
            if (of != null && of.func_221466_a() > ret.heal) {
                ret.effects = of.func_221464_f();
                ret.heal = of.func_221466_a();
                ret.sat = of.func_221469_b();
                ret.setRepersent(iis);
            }
            return ret;
        }
        return null;
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        if (recipes.size() == 0) {
            return;
        }
        logger.info("Building recipes...");
        Stopwatch sw = Stopwatch.createStarted();
        BowlContainingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BowlContainingRecipe.class, BowlContainingRecipe.TYPE).collect(Collectors.toMap(e -> e.fluid, UnaryOperator.identity()));
        FoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FoodValueRecipe.class, FoodValueRecipe.TYPE).flatMap(t -> t.processtimes.keySet().stream().map(i -> new Pair(i, t))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        List irs = recipeManager.func_241447_a_(IRecipeType.field_222152_d);
        DissolveRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DissolveRecipe.class, DissolveRecipe.TYPE).collect(Collectors.toList());
        CookingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, CookingRecipe.class, CookingRecipe.TYPE).collect(Collectors.toMap(e -> e.output, UnaryOperator.identity()));
        BoilingRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, BoilingRecipe.class, BoilingRecipe.TYPE).collect(Collectors.toMap(e -> e.before, UnaryOperator.identity()));
        FluidFoodValueRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, FluidFoodValueRecipe.class, FluidFoodValueRecipe.TYPE).collect(Collectors.toMap(e -> e.f, UnaryOperator.identity()));
        CountingTags.tags = Stream.concat(RecipeReloadListener.filterRecipes(recipes, CountingTags.class, CountingTags.TYPE).flatMap(r -> r.tag.stream()), CookingRecipe.recipes.values().stream().flatMap(CookingRecipe::getTags)).collect(Collectors.toSet());
        CookingRecipe.cookables = CookingRecipe.recipes.values().stream().flatMap(CookingRecipe::getAllNumbers).collect(Collectors.toSet());
        for (Item i : ForgeRegistries.ITEMS) {
            ItemStack iis = new ItemStack((IItemProvider)i);
            if (FoodValueRecipe.recipes.containsKey(i) || DissolveRecipe.recipes.stream().anyMatch(e -> e.test(iis))) continue;
            RecipeReloadListener.addCookingTime(i, iis, irs, false);
        }
        FoodValueRecipe.recipeset = new HashSet<FoodValueRecipe>(FoodValueRecipe.recipes.values());
        CookingRecipe.sorted = new ArrayList<CookingRecipe>(CookingRecipe.recipes.values());
        CookingRecipe.sorted.sort((t2, t1) -> t1.getPriority() - t2.getPriority());
        sw.stop();
        logger.info("Recipes built, cost {}", (Object)sw);
    }

    static <R extends IRecipe<?>> Stream<R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<?> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).map(recipeClass::cast);
    }
}

