/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.InvalidRecipeException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeSerializer<T extends IDataRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    BiFunction<ResourceLocation, JsonObject, T> jsfactory;
    BiFunction<ResourceLocation, PacketBuffer, T> pkfactory;
    BiConsumer<T, PacketBuffer> writer;
    static final Logger logger = LogManager.getLogger((String)"thermopolium recipe serialize");

    public T read(ResourceLocation recipeId, JsonObject json) {
        try {
            return (T)((IDataRecipe)this.jsfactory.apply(recipeId, json));
        }
        catch (InvalidRecipeException e) {
            return null;
        }
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        return (T)((IDataRecipe)this.pkfactory.apply(recipeId, buffer));
    }

    public void write(PacketBuffer buffer, T recipe) {
        this.writer.accept(recipe, buffer);
    }

    public RecipeSerializer(BiFunction<ResourceLocation, JsonObject, T> jsfactory, BiFunction<ResourceLocation, PacketBuffer, T> pkfactory, BiConsumer<T, PacketBuffer> writer) {
        this.jsfactory = jsfactory;
        this.pkfactory = pkfactory;
        this.writer = writer;
    }
}

