/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.InvalidRecipeException;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BoilingRecipe
extends IDataRecipe {
    public static Map<Fluid, BoilingRecipe> recipes;
    public static IRecipeType<?> TYPE;
    public static RegistryObject<IRecipeSerializer<?>> SERIALIZER;
    public Fluid before;
    public Fluid after;
    public int time;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public BoilingRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.before = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("from").getAsString()));
        this.after = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("to").getAsString()));
        this.time = jo.get("time").getAsInt();
        if (this.before == Fluids.field_204541_a || this.after == Fluids.field_204541_a) {
            throw new InvalidRecipeException();
        }
    }

    public BoilingRecipe(ResourceLocation id, PacketBuffer data) {
        super(id);
        this.before = (Fluid)data.readRegistryId();
        this.after = (Fluid)data.readRegistryId();
        this.time = data.func_150792_a();
    }

    public BoilingRecipe(ResourceLocation id, Fluid before, Fluid after, int time) {
        super(id);
        this.before = before;
        this.after = after;
        this.time = time;
    }

    public void write(PacketBuffer data) {
        data.writeRegistryId((IForgeRegistryEntry)this.before);
        data.writeRegistryId((IForgeRegistryEntry)this.after);
        data.func_150787_b(this.time);
    }

    public void func_218610_a(JsonObject json) {
        json.addProperty("from", this.before.getRegistryName().toString());
        json.addProperty("to", this.after.getRegistryName().toString());
        json.addProperty("time", (Number)this.time);
    }

    public FluidStack handle(FluidStack org) {
        FluidStack fs = new FluidStack(this.after, org.getAmount());
        if (org.hasTag()) {
            fs.setTag(org.getTag());
        }
        return fs;
    }
}

