/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.InvalidRecipeException;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BowlContainingRecipe
extends IDataRecipe {
    public static Map<Fluid, BowlContainingRecipe> recipes;
    public static IRecipeType<?> TYPE;
    public static RegistryObject<IRecipeSerializer<?>> SERIALIZER;
    public Item bowl;
    public Fluid fluid;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public BowlContainingRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.bowl = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jo.get("item").getAsString()));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("fluid").getAsString()));
        if (this.bowl == null || this.bowl == Items.field_190931_a || this.fluid == null || this.fluid == Fluids.field_204541_a) {
            throw new InvalidRecipeException();
        }
    }

    public BowlContainingRecipe(ResourceLocation id, PacketBuffer pb) {
        super(id);
        this.bowl = (Item)pb.readRegistryId();
        this.fluid = (Fluid)pb.readRegistryId();
    }

    public BowlContainingRecipe(ResourceLocation id, Item bowl, Fluid fluid) {
        super(id);
        this.bowl = bowl;
        this.fluid = fluid;
    }

    public void write(PacketBuffer pack) {
        pack.writeRegistryId((IForgeRegistryEntry)this.bowl);
        pack.writeRegistryId((IForgeRegistryEntry)this.fluid);
    }

    public void func_218610_a(JsonObject jo) {
        jo.addProperty("item", this.bowl.getRegistryName().toString());
        jo.addProperty("fluid", this.fluid.getRegistryName().toString());
    }

    public ItemStack handle(Fluid f) {
        ItemStack is = new ItemStack((IItemProvider)this.bowl);
        is.func_196082_o().func_74778_a("type", f.getRegistryName().toString());
        return is;
    }

    public ItemStack handle(FluidStack stack) {
        ItemStack is = new ItemStack((IItemProvider)this.bowl);
        if (stack.hasTag()) {
            is.func_77982_d(stack.getTag());
        }
        is.func_196082_o().func_74778_a("type", stack.getFluid().getRegistryName().toString());
        return is;
    }

    public static FluidStack extractFluid(ItemStack item) {
        Fluid f;
        CompoundNBT tag;
        if (item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("type") && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("type")))) != null) {
            FluidStack res = new FluidStack(f, 250);
            CompoundNBT ntag = tag.func_74737_b();
            ntag.func_82580_o("type");
            if (!ntag.isEmpty()) {
                res.setTag(ntag);
            }
            return res;
        }
        return FluidStack.EMPTY;
    }
}

