/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.InvalidRecipeException;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import com.teammoeg.thermopolium.data.recipes.StewBaseCondition;
import com.teammoeg.thermopolium.data.recipes.StewCondition;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CookingRecipe
extends IDataRecipe {
    public static Set<StewNumber> cookables;
    public static Map<Fluid, CookingRecipe> recipes;
    public static List<CookingRecipe> sorted;
    public static IRecipeType<?> TYPE;
    public static RegistryObject<IRecipeSerializer<?>> SERIALIZER;
    public static final ResourceLocation cookable;
    public static final ResourceLocation boilable;
    List<StewCondition> allow;
    List<StewCondition> deny;
    int priority = 0;
    public int time;
    float density;
    List<StewBaseCondition> base;
    public Fluid output;

    public static boolean isCookable(ItemStack stack) {
        FloatemTagStack s = new FloatemTagStack(stack);
        return stack.func_77973_b().getTags().contains(cookable) || cookables.stream().anyMatch(e -> e.fits(s));
    }

    public static boolean isBoilable(FluidStack f) {
        Fluid fd = f.getFluid();
        return fd instanceof SoupFluid || fd.getTags().contains(boilable) || recipes.keySet().contains(fd);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public CookingRecipe(ResourceLocation id) {
        super(id);
    }

    public CookingRecipe(ResourceLocation id, JsonObject data) {
        super(id);
        if (data.has("allow")) {
            this.allow = SerializeUtil.parseJsonList(data.get("allow"), SerializeUtil::ofCondition);
        }
        if (data.has("deny")) {
            this.deny = SerializeUtil.parseJsonList(data.get("deny"), SerializeUtil::ofCondition);
        }
        if (data.has("priority")) {
            this.priority = data.get("priority").getAsInt();
        }
        if (data.has("density")) {
            this.density = data.get("density").getAsFloat();
        }
        this.time = data.get("time").getAsInt();
        if (data.has("base")) {
            this.base = SerializeUtil.parseJsonList(data.get("base"), SerializeUtil::ofBase);
        }
        this.output = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(data.get("output").getAsString()));
        if (this.output == Fluids.field_204541_a) {
            throw new InvalidRecipeException();
        }
    }

    public CookingRecipe(ResourceLocation id, PacketBuffer data) {
        super(id);
        this.allow = SerializeUtil.readList(data, SerializeUtil::ofCondition);
        this.deny = SerializeUtil.readList(data, SerializeUtil::ofCondition);
        this.priority = data.func_150792_a();
        this.density = data.readFloat();
        this.time = data.func_150792_a();
        this.base = SerializeUtil.readList(data, SerializeUtil::ofBase);
        this.output = (Fluid)data.readRegistryId();
    }

    public CookingRecipe(ResourceLocation id, List<StewCondition> allow, List<StewCondition> deny, int priority, int time, float density, List<StewBaseCondition> base, Fluid output) {
        super(id);
        this.allow = allow;
        this.deny = deny;
        this.priority = priority;
        this.time = time;
        this.density = density;
        this.base = base;
        this.output = output;
    }

    public void write(PacketBuffer data) {
        SerializeUtil.writeList(data, this.allow, SerializeUtil::write);
        SerializeUtil.writeList(data, this.deny, SerializeUtil::write);
        data.func_150787_b(this.priority);
        data.writeFloat(this.density);
        data.func_150787_b(this.time);
        SerializeUtil.writeList(data, this.base, SerializeUtil::write);
        data.writeRegistryId((IForgeRegistryEntry)this.output);
    }

    public int matches(StewPendingContext ctx) {
        if (ctx.getTotalItems() < this.density) {
            return 0;
        }
        int matchtype = 0;
        if (this.base != null) {
            StewBaseCondition e;
            Iterator<StewBaseCondition> iterator = this.base.iterator();
            while (iterator.hasNext() && (matchtype = ctx.compute(e = iterator.next())) == 0) {
            }
            if (matchtype == 0) {
                return 0;
            }
        }
        if (matchtype == 0) {
            matchtype = 1;
        }
        if (this.allow != null) {
            if (!this.allow.stream().allMatch(ctx::compute)) {
                return 0;
            }
        }
        if (this.deny != null) {
            if (this.deny.stream().anyMatch(ctx::compute)) {
                return 0;
            }
        }
        return matchtype;
    }

    public void func_218610_a(JsonObject json) {
        if (this.allow != null && !this.allow.isEmpty()) {
            json.add("allow", (JsonElement)SerializeUtil.toJsonList(this.allow, StewCondition::serialize));
        }
        if (this.deny != null && !this.deny.isEmpty()) {
            json.add("deny", (JsonElement)SerializeUtil.toJsonList(this.deny, StewCondition::serialize));
        }
        if (this.priority != 0) {
            json.addProperty("priority", (Number)this.priority);
        }
        json.addProperty("density", (Number)Float.valueOf(this.density));
        json.addProperty("time", (Number)this.time);
        if (this.base != null && !this.base.isEmpty()) {
            json.add("base", (JsonElement)SerializeUtil.toJsonList(this.base, StewBaseCondition::serialize));
        }
        json.addProperty("output", this.output.getRegistryName().toString());
    }

    public Stream<StewNumber> getAllNumbers() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(StewCondition::getAllNumbers), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(StewCondition::getAllNumbers));
    }

    public Stream<ResourceLocation> getTags() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(StewCondition::getTags), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(StewCondition::getTags));
    }

    public int getPriority() {
        return this.priority;
    }

    public List<StewBaseCondition> getBase() {
        return this.base;
    }

    public List<StewCondition> getAllow() {
        return this.allow;
    }

    public List<StewCondition> getDeny() {
        return this.deny;
    }

    public float getDensity() {
        return this.density;
    }

    static {
        cookable = new ResourceLocation("thermopolium", "cookable");
        boilable = new ResourceLocation("thermopolium", "boilable");
    }
}

