/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFoodValueRecipe
extends IDataRecipe {
    public static Map<ResourceLocation, FluidFoodValueRecipe> recipes;
    public static IRecipeType<?> TYPE;
    public static RegistryObject<IRecipeSerializer<?>> SERIALIZER;
    public int heal;
    public float sat;
    public List<Pair<EffectInstance, Float>> effects;
    private ItemStack repersent;
    public int parts;
    public ResourceLocation f;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public FluidFoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack repersent, int parts, Fluid f) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.repersent = repersent;
        this.parts = parts;
        this.f = f.getRegistryName();
    }

    public FluidFoodValueRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        ItemStack[] i;
        this.heal = jo.get("heal").getAsInt();
        this.sat = jo.get("sat").getAsFloat();
        this.f = new ResourceLocation(jo.get("fluid").getAsString());
        this.parts = jo.has("parts") ? jo.get("parts").getAsInt() : 1;
        this.effects = SerializeUtil.parseJsonList(jo.get("effects"), x -> {
            Effect eff;
            int amplifier = 0;
            if (x.has("level")) {
                amplifier = x.get("level").getAsInt();
            }
            int duration = 0;
            if (x.has("time")) {
                duration = x.get("time").getAsInt();
            }
            if ((eff = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(x.get("effect").getAsString()))) == null) {
                return null;
            }
            EffectInstance effect = new EffectInstance(eff, duration, amplifier);
            float f = 1.0f;
            if (x.has("chance")) {
                f = x.get("chance").getAsInt();
            }
            return new Pair((Object)effect, (Object)Float.valueOf(f));
        });
        if (this.effects != null) {
            this.effects.removeIf(e -> e == null);
        }
        if (jo.has("item") && (i = Ingredient.func_199802_a((JsonElement)jo.get("item")).func_193365_a()).length > 0) {
            this.repersent = i[0];
        }
    }

    public void func_218610_a(JsonObject json) {
        json.addProperty("heal", (Number)this.heal);
        json.addProperty("sat", (Number)Float.valueOf(this.sat));
        json.addProperty("parts", (Number)this.parts);
        json.addProperty("fluid", this.f.toString());
        if (this.effects != null && !this.effects.isEmpty()) {
            json.add("effects", (JsonElement)SerializeUtil.toJsonList(this.effects, x -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("level", (Number)((EffectInstance)x.getFirst()).func_76458_c());
                jo.addProperty("time", (Number)((EffectInstance)x.getFirst()).func_76459_b());
                jo.addProperty("effect", ((EffectInstance)x.getFirst()).func_188419_a().getRegistryName().toString());
                jo.addProperty("chance", (Number)x.getSecond());
                return jo;
            }));
        }
        if (this.repersent != null) {
            json.add("item", Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.repersent}).func_200304_c());
        }
    }

    public FluidFoodValueRecipe(ResourceLocation id, PacketBuffer data) {
        super(id);
        this.heal = data.func_150792_a();
        this.sat = data.readFloat();
        this.parts = data.func_150792_a();
        this.f = data.func_192575_l();
        this.effects = SerializeUtil.readList(data, d -> new Pair((Object)EffectInstance.func_82722_b((CompoundNBT)d.func_150793_b()), (Object)Float.valueOf(d.readFloat())));
        this.repersent = SerializeUtil.readOptional(data, d -> ItemStack.func_199557_a((CompoundNBT)d.func_150793_b())).orElse(null);
    }

    public FluidFoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack repersent, int parts, ResourceLocation f) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.repersent = repersent;
        this.parts = parts;
        this.f = f;
    }

    public void write(PacketBuffer data) {
        data.func_150787_b(this.heal);
        data.writeFloat(this.sat);
        data.func_150787_b(this.parts);
        data.func_192572_a(this.f);
        SerializeUtil.writeList2(data, this.effects, (d, e) -> {
            CompoundNBT nc = new CompoundNBT();
            ((EffectInstance)e.getFirst()).func_82719_a(nc);
            d.func_150786_a(nc);
            d.writeFloat(((Float)e.getSecond()).floatValue());
        });
        SerializeUtil.writeOptional(data, this.repersent, (d, e) -> e.func_150786_a(d.serializeNBT()));
    }

    public ItemStack getRepersent() {
        return this.repersent;
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? repersent.func_77946_l() : null;
    }
}

