/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.data.IDataRecipe;
import com.teammoeg.thermopolium.data.recipes.CountingTags;
import com.teammoeg.thermopolium.data.recipes.InvalidRecipeException;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FoodValueRecipe
extends IDataRecipe {
    public static Map<Item, FoodValueRecipe> recipes;
    public static IRecipeType<?> TYPE;
    public static RegistryObject<IRecipeSerializer<?>> SERIALIZER;
    public static Set<FoodValueRecipe> recipeset;
    public int heal;
    public float sat;
    public List<Pair<EffectInstance, Float>> effects;
    public final Map<Item, Integer> processtimes;
    private ItemStack repersent;
    public transient Set<ResourceLocation> tags;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public FoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack rps, Item ... types) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.processtimes = new LinkedHashMap<Item, Integer>();
        this.repersent = rps;
        for (Item i : types) {
            this.processtimes.put(i, 0);
        }
    }

    public FoodValueRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        ItemStack[] i;
        this.heal = jo.get("heal").getAsInt();
        this.sat = jo.get("sat").getAsFloat();
        this.processtimes = SerializeUtil.parseJsonList(jo.get("items"), x -> {
            ResourceLocation rl = new ResourceLocation(x.get("item").getAsString());
            if (ForgeRegistries.ITEMS.containsKey(rl)) {
                Item i = (Item)ForgeRegistries.ITEMS.getValue(rl);
                int f = 0;
                if (x.has("time")) {
                    f = x.get("time").getAsInt();
                }
                if (i == Items.field_190931_a) {
                    return null;
                }
                return new Pair((Object)i, (Object)f);
            }
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        if (this.processtimes.isEmpty()) {
            throw new InvalidRecipeException();
        }
        this.effects = SerializeUtil.parseJsonList(jo.get("effects"), x -> {
            ResourceLocation rl = new ResourceLocation(x.get("effect").getAsString());
            if (ForgeRegistries.POTIONS.containsKey(rl)) {
                Effect eff;
                int amplifier = 0;
                if (x.has("level")) {
                    amplifier = x.get("level").getAsInt();
                }
                int duration = 0;
                if (x.has("time")) {
                    duration = x.get("time").getAsInt();
                }
                if ((eff = (Effect)ForgeRegistries.POTIONS.getValue(rl)) == null) {
                    return null;
                }
                EffectInstance effect = new EffectInstance(eff, duration, amplifier);
                float f = 1.0f;
                if (x.has("chance")) {
                    f = x.get("chance").getAsInt();
                }
                return new Pair((Object)effect, (Object)Float.valueOf(f));
            }
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.effects != null) {
            this.effects.removeIf(e -> e == null);
        }
        if (jo.has("item") && (i = Ingredient.func_199802_a((JsonElement)jo.get("item")).func_193365_a()).length > 0) {
            this.repersent = i[0];
        }
    }

    public FoodValueRecipe addEffect(EffectInstance effect, float chance) {
        if (this.effects == null) {
            this.effects = new ArrayList<Pair<EffectInstance, Float>>();
        }
        this.effects.add((Pair<EffectInstance, Float>)Pair.of((Object)effect, (Object)Float.valueOf(chance)));
        return this;
    }

    public void func_218610_a(JsonObject json) {
        json.addProperty("heal", (Number)this.heal);
        json.addProperty("sat", (Number)Float.valueOf(this.sat));
        if (this.processtimes != null && !this.processtimes.isEmpty()) {
            json.add("items", (JsonElement)SerializeUtil.toJsonList(this.processtimes.entrySet(), e -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("item", ((Item)e.getKey()).getRegistryName().toString());
                if ((Integer)e.getValue() != 0) {
                    jo.addProperty("time", (Number)e.getValue());
                }
                return jo;
            }));
        }
        if (this.effects != null && !this.effects.isEmpty()) {
            json.add("effects", (JsonElement)SerializeUtil.toJsonList(this.effects, x -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("level", (Number)((EffectInstance)x.getFirst()).func_76458_c());
                jo.addProperty("time", (Number)((EffectInstance)x.getFirst()).func_76459_b());
                jo.addProperty("effect", ((EffectInstance)x.getFirst()).func_188419_a().getRegistryName().toString());
                jo.addProperty("chance", (Number)x.getSecond());
                return jo;
            }));
        }
        if (this.repersent != null) {
            json.add("item", Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.repersent}).func_200304_c());
        }
    }

    public FoodValueRecipe(ResourceLocation id, PacketBuffer data) {
        super(id);
        this.heal = data.func_150792_a();
        this.sat = data.readFloat();
        this.processtimes = SerializeUtil.readList(data, d -> new Pair((Object)d.readRegistryId(), (Object)d.func_150792_a())).stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.effects = SerializeUtil.readList(data, d -> new Pair((Object)EffectInstance.func_82722_b((CompoundNBT)d.func_150793_b()), (Object)Float.valueOf(d.readFloat())));
        this.repersent = SerializeUtil.readOptional(data, d -> ItemStack.func_199557_a((CompoundNBT)d.func_150793_b())).orElse(null);
    }

    public void write(PacketBuffer data) {
        data.func_150787_b(this.heal);
        data.writeFloat(this.sat);
        SerializeUtil.writeList2(data, this.processtimes.entrySet(), (d, e) -> {
            d.writeRegistryId((IForgeRegistryEntry)e.getKey());
            d.func_150787_b(((Integer)e.getValue()).intValue());
        });
        SerializeUtil.writeList2(data, this.effects, (d, e) -> {
            CompoundNBT nc = new CompoundNBT();
            ((EffectInstance)e.getFirst()).func_82719_a(nc);
            d.func_150786_a(nc);
            d.writeFloat(((Float)e.getSecond()).floatValue());
        });
        SerializeUtil.writeOptional(data, this.repersent, (d, e) -> e.func_150786_a(d.serializeNBT()));
    }

    public void clearCache() {
        this.tags = null;
    }

    public Set<ResourceLocation> getTags() {
        if (this.tags == null) {
            this.tags = this.processtimes.keySet().stream().map(Item::getTags).flatMap(Collection::stream).filter(CountingTags.tags::contains).collect(Collectors.toSet());
        }
        return this.tags;
    }

    public ItemStack getRepersent() {
        return this.repersent;
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? repersent.func_77946_l() : null;
    }
}

