/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes;

import com.teammoeg.thermopolium.data.recipes.StewBaseCondition;
import com.teammoeg.thermopolium.data.recipes.StewCondition;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.util.FloatemStack;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import com.teammoeg.thermopolium.util.ResultCachingMap;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class StewPendingContext {
    private List<FloatemTagStack> items;
    private float totalTypes;
    private float totalItems;
    private SoupInfo info;
    ResourceLocation cur;
    private ResultCachingMap<StewNumber, Float> numbers = new ResultCachingMap<StewNumber, Float>(e -> (Float)e.apply(this));
    private ResultCachingMap<StewCondition, Boolean> results = new ResultCachingMap<StewCondition, Boolean>(e -> e.test(this));
    private ResultCachingMap<StewBaseCondition, Integer> basetypes = new ResultCachingMap<StewBaseCondition, Integer>(e -> (Integer)e.apply(this.info.base, this.cur));

    public ResourceLocation getCur() {
        return this.cur;
    }

    public StewPendingContext(SoupInfo info, ResourceLocation current) {
        this.info = info;
        this.items = new ArrayList<FloatemTagStack>(info.stacks.size());
        for (FloatemStack fs : info.stacks) {
            FloatemTagStack fst = new FloatemTagStack(fs);
            this.items.add(fst);
            this.totalItems += fs.getCount();
        }
        this.cur = current;
    }

    public float compute(StewNumber sn) {
        return this.numbers.compute(sn).floatValue();
    }

    public boolean compute(StewCondition sc) {
        return this.results.compute(sc);
    }

    public int compute(StewBaseCondition sbc) {
        return this.basetypes.compute(sbc);
    }

    public float getOfType(ResourceLocation rl) {
        return (float)this.items.stream().filter(e -> e.getTags().contains(rl)).mapToDouble(FloatemTagStack::getCount).sum();
    }

    public float getOfItem(Predicate<ItemStack> pred) {
        for (FloatemTagStack fs : this.items) {
            if (!pred.test(fs.getStack())) continue;
            return fs.getCount();
        }
        return 0.0f;
    }

    public float getTotalTypes() {
        return this.totalTypes;
    }

    public float getTotalItems() {
        return this.totalItems;
    }

    public SoupInfo getInfo() {
        return this.info;
    }

    public List<FloatemTagStack> getItems() {
        return this.items;
    }
}

