/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.baseconditions;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewBaseCondition;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTag
implements StewBaseCondition {
    ResourceLocation tag;

    public FluidTag(JsonObject jo) {
        this.tag = new ResourceLocation(jo.get("tag").getAsString());
    }

    public FluidTag(ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Integer apply(ResourceLocation t, ResourceLocation u) {
        return this.test(u) ? 2 : (this.test(t) ? 1 : 0);
    }

    public boolean test(ResourceLocation t) {
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(t);
        if (f == null) {
            return false;
        }
        return f.getTags().contains(this.tag);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = new JsonObject();
        jo.addProperty("tag", this.tag.toString());
        return jo;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.tag);
    }

    public FluidTag(PacketBuffer buffer) {
        this.tag = buffer.func_192575_l();
    }

    @Override
    public String getType() {
        return "tag";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FluidTag)) {
            return false;
        }
        FluidTag other = (FluidTag)obj;
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("tag." + this.tag.toString().replaceAll("[:/]", "."), new Object[0]);
    }
}

