/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.conditions;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.data.recipes.conditions.NumberedStewCondition;
import net.minecraft.network.PacketBuffer;

public class Halfs
extends NumberedStewCondition {
    private boolean isItem = true;

    public Halfs(JsonObject obj) {
        super(obj);
        if (obj.has("isItem")) {
            this.isItem = obj.get("isItem").getAsBoolean();
        }
    }

    public Halfs(StewNumber number) {
        super(number);
    }

    public Halfs(StewNumber number, boolean isItem) {
        super(number);
        this.isItem = isItem;
    }

    @Override
    public boolean test(StewPendingContext t, float n) {
        if (this.isItem) {
            return n > t.getTotalItems() / 2.0f;
        }
        return n > t.getTotalTypes() / 2.0f;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = super.serialize();
        if (!this.isItem) {
            jo.addProperty("isItem", Boolean.valueOf(this.isItem));
        }
        return jo;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.isItem);
    }

    public Halfs(PacketBuffer buffer) {
        super(buffer);
        this.isItem = buffer.readBoolean();
    }

    @Override
    public String getType() {
        return "half";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isItem ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Halfs)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Halfs other = (Halfs)obj;
        return this.isItem == other.isItem;
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("recipe.thermopolium.cond.half", this.number.getTranslation(p));
    }
}

