/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.conditions;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.data.recipes.conditions.NumberedStewCondition;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import net.minecraft.network.PacketBuffer;

public class Mainly
extends NumberedStewCondition {
    private boolean isItem = true;

    public Mainly(JsonObject obj) {
        super(obj);
        if (obj.has("isItem")) {
            this.isItem = obj.get("isItem").getAsBoolean();
        }
    }

    public Mainly(StewNumber number) {
        super(number);
    }

    public Mainly(StewNumber number, boolean isItem) {
        this(number);
        this.isItem = isItem;
    }

    @Override
    public boolean test(StewPendingContext t, float n) {
        if (this.isItem ? n < t.getTotalItems() / 3.0f : n < t.getTotalTypes() / 3.0f) {
            return false;
        }
        return FloatemTagStack.calculateTypes(t.getItems().stream().filter(e -> !this.number.fits((FloatemTagStack)e))).values().stream().allMatch(e -> e.floatValue() < n);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = super.serialize();
        if (!this.isItem) {
            jo.addProperty("isItem", Boolean.valueOf(this.isItem));
        }
        return jo;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.isItem);
    }

    public Mainly(PacketBuffer buffer) {
        super(buffer);
        this.isItem = buffer.readBoolean();
    }

    @Override
    public String getType() {
        return "mainly";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isItem ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mainly)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Mainly other = (Mainly)obj;
        return this.isItem == other.isItem;
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("recipe.thermopolium.cond.mainly", this.number.getTranslation(p));
    }
}

