/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.conditions;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.data.recipes.conditions.NumberedStewCondition;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class MainlyOfType
extends NumberedStewCondition {
    private final ResourceLocation type;

    public MainlyOfType(JsonObject obj) {
        super(obj);
        this.type = new ResourceLocation(obj.get("tag").getAsString());
    }

    public MainlyOfType(StewNumber obj, ResourceLocation type) {
        super(obj);
        this.type = type;
    }

    @Override
    public boolean test(StewPendingContext t, float n) {
        float thistype = t.getOfType(this.type);
        if (n < thistype / 3.0f) {
            return false;
        }
        return FloatemTagStack.calculateTypes(t.getItems().stream().filter(e -> e.getTags().contains(this.type)).filter(e -> !this.number.fits((FloatemTagStack)e))).values().stream().allMatch(e -> e.floatValue() < n);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = super.serialize();
        jo.addProperty("tag", this.type.toString());
        return jo;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_192572_a(this.type);
    }

    public MainlyOfType(PacketBuffer buffer) {
        super(buffer);
        this.type = buffer.func_192575_l();
    }

    @Override
    public String getType() {
        return "mainlyOf";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MainlyOfType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MainlyOfType other = (MainlyOfType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.concat(super.getTags(), Stream.of(this.type));
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("recipe.thermopolium.cond.mainlyof", this.number.getTranslation(p), p.getTranslation("tag." + this.type.toString().replaceAll("[:/]", "."), new Object[0]));
    }
}

