/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.conditions;

import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import com.teammoeg.thermopolium.data.recipes.StewCondition;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public abstract class NumberedStewCondition
implements StewCondition {
    protected StewNumber number;

    public NumberedStewCondition(JsonObject obj) {
        this.number = SerializeUtil.ofNumber(obj.get("type"));
    }

    public NumberedStewCondition(StewNumber number) {
        this.number = number;
    }

    @Override
    public boolean test(StewPendingContext t) {
        return this.test(t, t.compute(this.number));
    }

    public abstract boolean test(StewPendingContext var1, float var2);

    @Override
    public void write(PacketBuffer buffer) {
        SerializeUtil.write(this.number, buffer);
    }

    public NumberedStewCondition(PacketBuffer buffer) {
        this.number = SerializeUtil.ofNumber(buffer);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = new JsonObject();
        jo.addProperty("cond", this.getType());
        jo.add("type", this.number.serialize());
        return jo;
    }

    @Override
    public Stream<StewNumber> getAllNumbers() {
        return Stream.of(this.number);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumberedStewCondition)) {
            return false;
        }
        NumberedStewCondition other = (NumberedStewCondition)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return this.number.getTags();
    }
}

