/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.ComplexCalculated;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.data.recipes.Writeable;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class Add
implements StewNumber,
ComplexCalculated {
    List<StewNumber> nums;

    public Add(JsonElement jo) {
        if (jo.isJsonObject()) {
            this.nums = SerializeUtil.parseJsonElmList((JsonElement)jo.getAsJsonObject().get("types").getAsJsonArray(), SerializeUtil::ofNumber);
        } else if (jo.isJsonArray()) {
            this.nums = SerializeUtil.parseJsonElmList((JsonElement)jo.getAsJsonArray(), SerializeUtil::ofNumber);
        }
    }

    public Add() {
        this(new ArrayList<StewNumber>());
    }

    public Add(List<StewNumber> nums) {
        this.nums = nums;
    }

    @Override
    public Float apply(StewPendingContext t) {
        return this.nums.stream().map(t::compute).reduce(Float.valueOf(0.0f), Float::sum);
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return this.nums.stream().anyMatch(s -> s.fits(stack));
    }

    public void add(StewNumber sn) {
        this.nums.add(sn);
    }

    @Override
    public JsonElement serialize() {
        return SerializeUtil.toJsonList(this.nums, Writeable::serialize);
    }

    @Override
    public void write(PacketBuffer buffer) {
        SerializeUtil.writeList(buffer, this.nums, SerializeUtil::write);
    }

    public Add(PacketBuffer buffer) {
        this.nums = SerializeUtil.readList(buffer, SerializeUtil::ofNumber);
    }

    @Override
    public String getType() {
        return "add";
    }

    @Override
    public Stream<StewNumber> getItemRelated() {
        return this.nums.stream().flatMap(StewNumber::getItemRelated);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nums == null ? 0 : this.nums.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Add)) {
            return false;
        }
        Add other = (Add)obj;
        return !(this.nums == null ? other.nums != null : !this.nums.equals(other.nums));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return this.nums.stream().flatMap(StewNumber::getTags);
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return this.nums.stream().map(e -> e.getTranslation(p)).reduce((s1, s2) -> s1 + "+" + s2).orElse("");
    }
}

