/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConstNumber
implements StewNumber {
    float n;

    public ConstNumber(JsonElement num) {
        this.n = num.isJsonPrimitive() ? num.getAsFloat() : num.getAsJsonObject().get("num").getAsFloat();
    }

    public ConstNumber(float n) {
        this.n = n;
    }

    @Override
    public Float apply(StewPendingContext t) {
        return Float.valueOf(this.n);
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return false;
    }

    @Override
    public JsonElement serialize() {
        return new JsonPrimitive((Number)Float.valueOf(this.n));
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeFloat(this.n);
    }

    public ConstNumber(PacketBuffer buffer) {
        this.n = buffer.readFloat();
    }

    @Override
    public String getType() {
        return "const";
    }

    @Override
    public Stream<StewNumber> getItemRelated() {
        return Stream.empty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.n);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstNumber)) {
            return false;
        }
        ConstNumber other = (ConstNumber)obj;
        return Float.floatToIntBits(this.n) == Float.floatToIntBits(other.n);
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return String.valueOf(this.n);
    }
}

