/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ItemTag
implements StewNumber {
    ResourceLocation tag;

    public ItemTag(JsonElement jo) {
        this.tag = jo.isJsonObject() ? new ResourceLocation(jo.getAsJsonObject().get("tag").getAsString()) : new ResourceLocation(jo.getAsString());
    }

    public ItemTag(ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Float apply(StewPendingContext t) {
        return Float.valueOf(t.getOfType(this.tag));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getTags().contains(this.tag);
    }

    @Override
    public JsonElement serialize() {
        return new JsonPrimitive(this.tag.toString());
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.tag);
    }

    public ItemTag(PacketBuffer buffer) {
        this.tag = buffer.func_192575_l();
    }

    @Override
    public String getType() {
        return "tag";
    }

    @Override
    public Stream<StewNumber> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemTag)) {
            return false;
        }
        ItemTag other = (ItemTag)obj;
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.of(this.tag);
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation("tag." + this.tag.toString().replaceAll("[:/]", "."), new Object[0]);
    }
}

