/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.thermopolium.data.TranslationProvider;
import com.teammoeg.thermopolium.data.recipes.StewNumber;
import com.teammoeg.thermopolium.data.recipes.StewPendingContext;
import com.teammoeg.thermopolium.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemType
implements StewNumber {
    Item type;
    ResourceLocation loc;

    public ItemType(JsonElement jo) {
        this.loc = new ResourceLocation(jo.getAsJsonObject().get("item").getAsString());
        this.type = (Item)ForgeRegistries.ITEMS.getValue(this.loc);
    }

    public ItemType(Item type) {
        this.type = type;
        this.loc = type.getRegistryName();
    }

    @Override
    public Float apply(StewPendingContext t) {
        if (this.type == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(t.getOfItem(i -> i.func_77973_b().equals(this.type)));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getItem().equals(this.type);
    }

    @Override
    public JsonElement serialize() {
        JsonObject th = new JsonObject();
        th.addProperty("item", this.loc.toString());
        return th;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.loc);
    }

    public ItemType(PacketBuffer buffer) {
        this.loc = buffer.func_192575_l();
        this.type = (Item)ForgeRegistries.ITEMS.getValue(this.loc);
    }

    @Override
    public String getType() {
        return "item";
    }

    @Override
    public Stream<StewNumber> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemType)) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return !(this.loc == null ? other.loc != null : !this.loc.equals((Object)other.loc));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation(this.type.func_77658_a(), new Object[0]);
    }
}

