/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.event;

import com.teammoeg.thermopolium.api.ThermopoliumApi;
import com.teammoeg.thermopolium.data.RecipeReloadListener;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.fluid.SoupFluid;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeEvent {
    private static ResourceLocation container = new ResourceLocation("thermopolium", "container");

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new RecipeReloadListener(event.getDataPackRegistries()));
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack is = event.getItemStack();
        if (is.func_77973_b() == Items.field_151054_z) {
            BlockPos blockpos;
            PlayerEntity playerIn = event.getPlayer();
            World worldIn = event.getWorld();
            TileEntity te = worldIn.func_175625_s(blockpos = event.getPos());
            if (te != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace()).ifPresent(handler -> {
                    FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
                    BowlContainingRecipe recipe = BowlContainingRecipe.recipes.get(stack.getFluid());
                    if (recipe != null && stack.getAmount() == 250 && (stack = handler.drain(stack, IFluidHandler.FluidAction.EXECUTE)).getAmount() == 250) {
                        ItemStack ret = recipe.handle(stack);
                        event.setCanceled(true);
                        event.setCancellationResult(ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K));
                        if (is.func_190916_E() > 1) {
                            is.func_190918_g(1);
                            if (!playerIn.func_191521_c(ret)) {
                                playerIn.func_71019_a(ret, false);
                            }
                        } else {
                            playerIn.func_184611_a(event.getHand(), ret);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        BlockPos blockpos;
        BlockState blockstate1;
        Fluid f;
        PlayerEntity playerIn;
        World worldIn;
        BlockRayTraceResult ray;
        ItemStack is = event.getItemStack();
        if (is.func_77973_b() == Items.field_151054_z && (ray = Item.func_219968_a((World)(worldIn = event.getWorld()), (PlayerEntity)(playerIn = event.getPlayer()), (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() == RayTraceResult.Type.BLOCK && (f = (blockstate1 = worldIn.func_180495_p(blockpos = ray.func_216350_a())).func_204520_s().func_206886_c()) != Fluids.field_204541_a) {
            BowlContainingRecipe recipe = BowlContainingRecipe.recipes.get(f);
            if (recipe == null) {
                return;
            }
            ItemStack ret = recipe.handle(f);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K));
            if (is.func_190916_E() > 1) {
                is.func_190918_g(1);
                if (!playerIn.func_191521_c(ret)) {
                    playerIn.func_71019_a(ret, false);
                }
            } else {
                playerIn.func_184611_a(event.getHand(), ret);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        IFluidHandlerItem data;
        ItemStack stack;
        LazyOptional cap;
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ServerPlayerEntity && (cap = (stack = event.getItem()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY)).isPresent() && stack.func_77973_b().getTags().contains(container) && (data = (IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0).getFluid() instanceof SoupFluid) {
            ThermopoliumApi.applyStew(event.getEntityLiving().field_70170_p, event.getEntityLiving(), SoupFluid.getInfo(data.getFluidInTank(0)));
        }
    }
}

