/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.event;

import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.Main;
import com.teammoeg.thermopolium.api.ThermopoliumApi;
import com.teammoeg.thermopolium.blocks.StewPotTileEntity;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="thermopolium", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : Contents.registeredBlocks) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
            catch (Throwable e) {
                Main.logger.error("Failed to register a block. ({})", (Object)block);
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : Contents.registeredItems) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            catch (Throwable e) {
                Main.logger.error("Failed to register an item. ({}, {})", (Object)item, (Object)item.getRegistryName());
                throw e;
            }
        }
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151054_z, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack func_82487_b(IBlockSource bp, ItemStack is) {
                Direction d = (Direction)bp.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos front = bp.func_180699_d().func_177972_a(d);
                FluidState fs = bp.func_197524_h().func_180495_p(front).func_204520_s();
                TileEntity te = bp.func_197524_h().func_175625_s(front);
                if (te != null) {
                    ItemStack ret;
                    LazyOptional ip = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d());
                    if (ip.isPresent() && (ret = (ItemStack)ThermopoliumApi.fillBowl((IFluidHandler)ip.resolve().get()).orElse(null)) != null) {
                        if (is.func_190916_E() == 1) {
                            return ret;
                        }
                        is.func_190918_g(1);
                        if (((DispenserTileEntity)bp.func_150835_j()).func_146019_a(ret) == -1) {
                            this.defaultBehaviour.dispense(bp, ret);
                        }
                    }
                    return is;
                }
                if (!fs.func_206888_e()) {
                    ItemStack ret = ThermopoliumApi.fillBowl(new FluidStack(fs.func_206886_c(), 250)).orElse(null);
                    if (ret != null) {
                        if (is.func_190916_E() == 1) {
                            return ret;
                        }
                        is.func_190918_g(1);
                        if (((DispenserTileEntity)bp.func_150835_j()).func_146019_a(ret) == -1) {
                            this.defaultBehaviour.dispense(bp, ret);
                        }
                    }
                    return is;
                }
                return this.defaultBehaviour.dispense(bp, is);
            }
        });
        DefaultDispenseItemBehavior idispenseitembehavior1 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                ServerWorld world = source.func_197524_h();
                Direction d = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos front = source.func_180699_d().func_177972_a(d);
                FluidState fs = source.func_197524_h().func_180495_p(front).func_204520_s();
                TileEntity te = source.func_197524_h().func_175625_s(front);
                if (te != null) {
                    FluidActionResult fa;
                    LazyOptional ip = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d());
                    if (ip.isPresent() && (fa = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)((IFluidHandler)ip.resolve().get()), null, (int)1250, null, (boolean)true)).isSuccess()) {
                        if (fa.getResult() != null) {
                            return fa.getResult();
                        }
                        stack.func_190918_g(1);
                    }
                    return stack;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151117_aB, (IDispenseItemBehavior)idispenseitembehavior1);
        DefaultDispenseItemBehavior ddib = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                FluidStack fs = BowlContainingRecipe.extractFluid(stack);
                Direction d = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos front = source.func_180699_d().func_177972_a(d);
                TileEntity te = source.func_197524_h().func_175625_s(front);
                if (!fs.isEmpty()) {
                    IFluidHandler handler;
                    LazyOptional ip;
                    if (te instanceof StewPotTileEntity) {
                        if (((StewPotTileEntity)te).tryAddFluid(fs)) {
                            ItemStack ret = stack.getContainerItem();
                            if (stack.func_190916_E() == 1) {
                                return ret;
                            }
                            stack.func_190918_g(1);
                            if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(ret) == -1) {
                                this.defaultBehaviour.dispense(source, ret);
                            }
                        }
                    } else if (te != null && (ip = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d())).isPresent() && (handler = (IFluidHandler)ip.resolve().get()).fill(fs, IFluidHandler.FluidAction.SIMULATE) == fs.getAmount()) {
                        handler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack ret = stack.getContainerItem();
                        if (stack.func_190916_E() == 1) {
                            return ret;
                        }
                        stack.func_190918_g(1);
                        if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(ret) == -1) {
                            this.defaultBehaviour.dispense(source, ret);
                        }
                    }
                    return stack;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        for (Item i : Contents.THPItems.stews) {
            DispenserBlock.func_199774_a((IItemProvider)i, (IDispenseItemBehavior)ddib);
        }
    }

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Fluid> event) {
        for (Fluid fluid : Contents.registeredFluids) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)fluid);
            }
            catch (Throwable e) {
                Main.logger.error("Failed to register a fluid. ({}, {})", (Object)fluid, (Object)fluid.getRegistryName());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<Effect> event) {
    }
}

