/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.fluid;

import com.google.common.collect.Lists;
import com.teammoeg.thermopolium.util.FloatemStack;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class SoupFluid
extends ForgeFlowingFluid {
    public Fluid func_210198_f() {
        return this;
    }

    public Fluid func_210197_e() {
        return this;
    }

    public Item func_204524_b() {
        return Items.field_190931_a;
    }

    protected BlockState func_204527_a(FluidState state) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this;
    }

    public boolean func_207193_c(FluidState p_207193_1_) {
        return true;
    }

    public static SoupInfo getInfo(FluidStack stack) {
        CompoundNBT nbt;
        if (stack.hasTag() && (nbt = stack.getChildTag("soup")) != null) {
            return new SoupInfo(nbt);
        }
        return new SoupInfo(stack.getFluid().getRegistryName());
    }

    public static void setInfo(FluidStack stack, SoupInfo si) {
        if (!si.isEmpty()) {
            stack.getOrCreateTag().func_218657_a("soup", (INBT)si.save());
        }
    }

    public static List<FloatemStack> getItems(FluidStack stack) {
        CompoundNBT nbt;
        if (stack.hasTag() && (nbt = stack.getChildTag("soup")) != null) {
            return SoupInfo.getStacks(nbt);
        }
        return Lists.newArrayList();
    }

    public int func_207192_d(FluidState p_207192_1_) {
        return 0;
    }

    public SoupFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static ResourceLocation getBase(FluidStack stack) {
        CompoundNBT nbt;
        if (stack.hasTag() && (nbt = stack.getChildTag("soup")) != null) {
            return new ResourceLocation(SoupInfo.getRegName(nbt));
        }
        return stack.getFluid().getRegistryName();
    }

    public static class SoupAttributes
    extends FluidAttributes {
        public SoupAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public int getColor(FluidStack stack) {
            return super.getColor();
        }

        public String getTranslationKey(FluidStack stack) {
            ResourceLocation f = stack.getFluid().getRegistryName();
            return "item." + f.func_110624_b() + "." + f.func_110623_a();
        }

        public ITextComponent getDisplayName(FluidStack stack) {
            return new TranslationTextComponent(this.getTranslationKey(stack));
        }

        public static FluidAttributes.Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            return new SoupAttributesBuilder(stillTexture, flowingTexture);
        }

        private static class SoupAttributesBuilder
        extends FluidAttributes.Builder {
            protected SoupAttributesBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
                super(stillTexture, flowingTexture, SoupAttributes::new);
            }
        }
    }
}

