/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.items;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.Contents;
import com.teammoeg.thermopolium.data.recipes.BowlContainingRecipe;
import com.teammoeg.thermopolium.util.FloatemStack;
import com.teammoeg.thermopolium.util.SoupInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class StewItem
extends Item {
    ItemStack capturedStack;
    ResourceLocation fluid;
    public static final Food fakefood = new Food.Builder().func_221456_a(4).func_221454_a(0.2f).func_221457_c().func_221451_a().func_221453_d();

    public ItemStack getContainerItem(ItemStack itemStack) {
        return super.getContainerItem(itemStack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return super.getItemStackLimit(stack);
    }

    public ItemStack func_77654_b(ItemStack itemstack, World worldIn, LivingEntity entityLiving) {
        SoupInfo si = StewItem.getInfo(itemstack);
        if (!worldIn.field_72995_K) {
            for (EffectInstance eff : si.effects) {
                if (eff == null) continue;
                entityLiving.func_195064_c(eff);
            }
            Random r = entityLiving.func_70681_au();
            for (Pair<EffectInstance, Float> ef : si.foodeffect) {
                if (!(r.nextFloat() < ((Float)ef.getSecond()).floatValue())) continue;
                entityLiving.func_195064_c((EffectInstance)ef.getFirst());
            }
        }
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (!worldIn.field_72995_K && !Float.isNaN(si.saturation)) {
                player.func_71024_bL().func_75122_a(si.healing, si.saturation);
            }
            if (player.field_71075_bZ.field_75098_d) {
                return itemstack;
            }
        }
        return new ItemStack((IItemProvider)Items.field_151054_z);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        SoupInfo info = StewItem.getInfo(stack);
        FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
        if (fs != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.thermopolium.main_ingredient", new Object[]{fs.getStack().func_151000_E()}));
        }
        StewItem.addPotionTooltip(info.effects, tooltip, 1.0f);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static SoupInfo getInfo(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT soupTag = stack.func_179543_a("soup");
            return soupTag == null ? new SoupInfo(new ResourceLocation(stack.func_77978_p().func_74779_i("type"))) : new SoupInfo(soupTag);
        }
        return new SoupInfo();
    }

    public static void addPotionTooltip(List<EffectInstance> list, List<ITextComponent> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (!list.isEmpty()) {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c())});
                }
                if (effectinstance.func_76459_b() > 20) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withDuration", new Object[]{iformattabletextcomponent, EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(StringTextComponent.field_240750_d_);
            lores.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
        }
    }

    public static void setInfo(ItemStack stack, SoupInfo si) {
        if (!si.isEmpty()) {
            stack.func_196082_o().func_218657_a("soup", (INBT)si.save());
        }
    }

    public static List<FloatemStack> getItems(ItemStack stack) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_179543_a("soup")) != null) {
            return SoupInfo.getStacks(nbt);
        }
        return Lists.newArrayList();
    }

    public static ResourceLocation getBase(ItemStack stack) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_179543_a("soup")) != null) {
            return new ResourceLocation(SoupInfo.getRegName(nbt));
        }
        return BowlContainingRecipe.extractFluid(stack).getFluid().getRegistryName();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack is = new ItemStack((IItemProvider)this);
            is.func_196082_o().func_74778_a("type", this.fluid.toString());
            items.add((Object)is);
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public StewItem(String name, ResourceLocation fluid, Item.Properties properties) {
        super(properties.func_221540_a(fakefood));
        this.setRegistryName("thermopolium", name);
        Contents.registeredItems.add(this);
        Contents.THPItems.stews.add(this);
        this.fluid = fluid;
    }

    public Food func_219967_s() {
        return super.func_219967_s();
    }
}

