/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.network;

import com.teammoeg.thermopolium.network.INetworkTile;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientDataMessage {
    private final short type;
    private final int message;
    private final BlockPos pos;

    public ClientDataMessage(BlockPos pos, short type, int message) {
        this.pos = pos;
        this.type = type;
        this.message = message;
    }

    ClientDataMessage(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.type = buffer.readShort();
        this.message = buffer.readInt();
    }

    void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeShort((int)this.type);
        buffer.writeInt(this.message);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity tile;
            ServerWorld world = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()).func_71121_q();
            if (world.isAreaLoaded(this.pos, 1) && (tile = world.func_175625_s(this.pos)) instanceof INetworkTile) {
                ((INetworkTile)tile).handleMessage(this.type, this.message);
            }
        });
        context.get().setPacketHandled(true);
    }
}

