/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammoeg.thermopolium.api.GameTranslation;
import com.teammoeg.thermopolium.data.recipes.CookingRecipe;
import com.teammoeg.thermopolium.data.recipes.StewCondition;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class AllowenceTooltip
implements ICustomComponent {
    boolean allow;
    int x;
    int y;
    int w;
    int h;
    IVariable recipe;
    transient List<ITextComponent> allowence;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipe = (IVariable)lookup.apply(this.recipe);
        ResourceLocation out = new ResourceLocation(this.recipe.asString());
        CookingRecipe cr = CookingRecipe.recipes.get(ForgeRegistries.FLUIDS.getValue(out));
        if (cr != null) {
            List<StewCondition> conds = this.allow ? cr.getAllow() : cr.getDeny();
            if (conds != null) {
                this.allowence = conds.stream().map(e -> e.getTranslation(GameTranslation.get())).map(StringTextComponent::new).collect(Collectors.toList());
            }
            if (this.allowence != null && !this.allowence.isEmpty()) {
                if (this.allow) {
                    this.allowence.add(0, (ITextComponent)new TranslationTextComponent("recipe.thermopolium.allow"));
                } else {
                    this.allowence.add(0, (ITextComponent)new TranslationTextComponent("recipe.thermopolium.deny"));
                }
            }
        }
    }

    public void build(int componentX, int componentY, int pageNum) {
    }

    public void render(MatrixStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        if (context.isAreaHovered(mouseX, mouseY, this.x, this.y, this.w, this.h) && this.allowence != null && !this.allowence.isEmpty()) {
            context.setHoverTooltipComponents(this.allowence);
        }
    }
}

