/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class FloatemStack {
    ItemStack stack;
    float count;

    public FloatemStack(ItemStack stack, float count) {
        this.stack = stack.func_77946_l();
        this.stack.func_190920_e(1);
        this.count = count;
    }

    public FloatemStack(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public FloatemStack(ItemStack is) {
        this(is, is.func_190916_E());
    }

    public ItemStack getStack() {
        return this.stack.getStack();
    }

    public ItemStack getContainerItem() {
        return this.stack.getContainerItem();
    }

    public boolean hasContainerItem() {
        return this.stack.hasContainerItem();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT cnbt = this.stack.serializeNBT();
        cnbt.func_74776_a("th_countf", this.count);
        return cnbt;
    }

    public boolean isEmpty() {
        return (double)this.count <= 0.001;
    }

    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getEntityLifespan(World world) {
        return this.stack.getEntityLifespan(world);
    }

    public CompoundNBT write(CompoundNBT nbt) {
        CompoundNBT cnbt = this.stack.func_77955_b(nbt);
        cnbt.func_74776_a("th_countf", this.count);
        return cnbt;
    }

    public int getMaxStackSize() {
        return this.stack.func_77976_d();
    }

    public boolean isStackable() {
        return this.stack.func_77985_e();
    }

    public boolean isDamageable() {
        return this.stack.func_77984_f();
    }

    public boolean isDamaged() {
        return this.stack.func_77951_h();
    }

    public int getDamage() {
        return this.stack.func_77952_i();
    }

    public void setDamage(int damage) {
        this.stack.func_196085_b(damage);
    }

    public int getMaxDamage() {
        return this.stack.func_77958_k();
    }

    public CompoundNBT getShareTag() {
        return this.stack.getShareTag();
    }

    public void readShareTag(CompoundNBT nbt) {
        this.stack.readShareTag(nbt);
    }

    public boolean areShareTagsEqual(ItemStack other) {
        return this.stack.areShareTagsEqual(other);
    }

    public FloatemStack copy() {
        return new FloatemStack(this.stack.func_77946_l(), this.count);
    }

    public boolean isItemEqual(ItemStack other) {
        return this.stack.func_77969_a(other);
    }

    public boolean isItemEqualIgnoreDurability(ItemStack stack) {
        return stack.func_185136_b(stack);
    }

    public String getTranslationKey() {
        return this.stack.func_77977_a();
    }

    public boolean hasTag() {
        return this.stack.func_77942_o();
    }

    public CompoundNBT getTag() {
        return this.stack.func_77978_p();
    }

    public CompoundNBT getOrCreateTag() {
        return this.stack.func_196082_o();
    }

    public CompoundNBT getOrCreateChildTag(String key) {
        return this.stack.func_190925_c(key);
    }

    public CompoundNBT getChildTag(String key) {
        return this.stack.func_179543_a(key);
    }

    public void removeChildTag(String p_196083_1_) {
        this.stack.func_196083_e(p_196083_1_);
    }

    public void setTag(CompoundNBT nbt) {
        this.stack.func_77982_d(nbt);
    }

    public ITextComponent getDisplayName() {
        return this.stack.func_200301_q();
    }

    public ItemStack setDisplayName(ITextComponent name) {
        return this.stack.func_200302_a(name);
    }

    public void clearCustomName() {
        this.stack.func_135074_t();
    }

    public boolean hasDisplayName() {
        return this.stack.func_82837_s();
    }

    public boolean hasEffect() {
        return this.stack.func_77962_s();
    }

    public Rarity getRarity() {
        return this.stack.func_77953_t();
    }

    public void setTagInfo(String key, INBT value) {
        this.stack.func_77983_a(key, value);
    }

    public ITextComponent getTextComponent() {
        return this.stack.func_151000_E();
    }

    public float getCount() {
        return this.count;
    }

    public void setCount(float count) {
        this.count = count;
    }

    public void grow(float count) {
        this.count += count;
    }

    public void shrink(float count) {
        this.count -= count;
        if (this.count < 0.0f) {
            this.count = 0.0f;
        }
    }

    public boolean isFood() {
        return this.stack.func_222117_E();
    }

    public boolean equals(ItemStack other) {
        if (this.getItem() != other.func_77973_b()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)this.getStack(), (ItemStack)other);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        this.count = nbt.func_74760_g("th_countf");
    }
}

