/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.util;

import com.teammoeg.thermopolium.data.recipes.CountingTags;
import com.teammoeg.thermopolium.data.recipes.FoodValueRecipe;
import com.teammoeg.thermopolium.util.FloatemStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FloatemTagStack {
    Set<ResourceLocation> tags;
    final ItemStack stack;
    float count;

    public FloatemTagStack(FloatemStack stack) {
        FoodValueRecipe fvr = FoodValueRecipe.recipes.get(stack.getItem());
        this.tags = fvr == null ? stack.getItem().getTags().stream().filter(CountingTags.tags::contains).collect(Collectors.toSet()) : fvr.getTags();
        this.stack = stack.stack;
        this.count = stack.count;
    }

    public FloatemTagStack(ItemStack stack) {
        FoodValueRecipe fvr = FoodValueRecipe.recipes.get(stack.func_77973_b());
        this.tags = fvr == null ? stack.func_77973_b().getTags().stream().filter(CountingTags.tags::contains).collect(Collectors.toSet()) : fvr.getTags();
        this.stack = stack;
        this.count = stack.func_190916_E();
    }

    public Set<ResourceLocation> getTags() {
        return this.tags;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getCount() {
        return this.count;
    }

    public static Map<ResourceLocation, Float> calculateTypes(Stream<FloatemTagStack> stacks) {
        HashMap<ResourceLocation, Float> map = new HashMap<ResourceLocation, Float>();
        stacks.forEach(e -> {
            float c = e.count;
            for (ResourceLocation tag : e.tags) {
                map.merge(tag, Float.valueOf(c), Float::sum);
            }
        });
        return map;
    }

    public Item getItem() {
        return this.stack.func_77973_b();
    }
}

