/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.util;

import com.teammoeg.thermopolium.data.recipes.ComplexCalculated;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.function.Function;

public class ResultCachingMap<T, U>
extends HashMap<T, U> {
    private static final long serialVersionUID = 1L;
    final Function<? super T, ? extends U> mapper;

    public ResultCachingMap(Function<? super T, ? extends U> mapper) {
        this.mapper = mapper;
    }

    public U compute(T sn) {
        if (sn instanceof ComplexCalculated) {
            return this.secureCompute(sn);
        }
        try {
            return this.computeIfAbsent(sn, this.mapper);
        }
        catch (ConcurrentModificationException cme) {
            return this.secureCompute(sn);
        }
    }

    private U secureCompute(T sn) {
        Object f = this.get(sn);
        if (f != null) {
            return (U)f;
        }
        f = this.mapper.apply(sn);
        this.put(sn, f);
        return (U)f;
    }
}

