/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.thermopolium.util;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.thermopolium.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.thermopolium.data.recipes.FoodValueRecipe;
import com.teammoeg.thermopolium.data.recipes.SerializeUtil;
import com.teammoeg.thermopolium.util.FloatemStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class SoupInfo {
    public List<FloatemStack> stacks;
    public List<EffectInstance> effects;
    public List<Pair<EffectInstance, Float>> foodeffect = new ArrayList<Pair<EffectInstance, Float>>();
    public int healing;
    public float saturation;
    public float shrinkedFluid = 0.0f;
    public ResourceLocation base;

    public SoupInfo(List<FloatemStack> stacks, List<EffectInstance> effects, int healing, float saturation, ResourceLocation base) {
        this.stacks = stacks;
        this.effects = effects;
        this.healing = healing;
        this.saturation = saturation;
        this.base = base;
    }

    public SoupInfo() {
        this(new ArrayList<FloatemStack>(), new ArrayList<EffectInstance>(), 0, 0.0f, new ResourceLocation("minecraft:water"));
    }

    public static List<FloatemStack> getStacks(CompoundNBT nbt) {
        return nbt.func_150295_c("items", 10).stream().map(e -> (CompoundNBT)e).map(FloatemStack::new).collect(Collectors.toList());
    }

    public float getDensity() {
        return this.stacks.stream().map(FloatemStack::getCount).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public SoupInfo(CompoundNBT nbt) {
        this.stacks = nbt.func_150295_c("items", 10).stream().map(e -> (CompoundNBT)e).map(FloatemStack::new).collect(Collectors.toList());
        this.effects = nbt.func_150295_c("effects", 10).stream().map(e -> (CompoundNBT)e).map(EffectInstance::func_82722_b).collect(Collectors.toList());
        this.healing = nbt.func_74762_e("heal");
        this.saturation = nbt.func_74760_g("sat");
        this.foodeffect = nbt.func_150295_c("feffects", 10).stream().map(e -> (CompoundNBT)e).map(e -> new Pair((Object)EffectInstance.func_82722_b((CompoundNBT)e.func_74775_l("effect")), (Object)Float.valueOf(e.func_74760_g("chance")))).collect(Collectors.toList());
        this.base = new ResourceLocation(nbt.func_74779_i("base"));
        this.shrinkedFluid = nbt.func_74760_g("afluid");
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty() && this.effects.isEmpty();
    }

    public boolean canMerge(SoupInfo f, float cparts, float oparts) {
        return (this.getDensity() * cparts + f.getDensity() * oparts) / (cparts + oparts) <= 3.0f;
    }

    public boolean merge(SoupInfo f, float cparts, float oparts) {
        boolean added;
        if (!this.canMerge(f, cparts, oparts)) {
            return false;
        }
        for (EffectInstance effectInstance : f.effects) {
            added = false;
            for (EffectInstance effectInstance2 : this.effects) {
                if (!SoupInfo.isEffectEquals(effectInstance2, effectInstance)) continue;
                effectInstance2.field_76460_b = (int)((float)effectInstance2.field_76460_b + (float)effectInstance.field_76460_b * oparts / cparts);
                added = true;
                break;
            }
            if (added || this.effects.size() >= 3) continue;
            EffectInstance copy = new EffectInstance(effectInstance);
            copy.field_76460_b = (int)((float)copy.field_76460_b * oparts / cparts);
            this.effects.add(copy);
        }
        for (Pair pair : f.foodeffect) {
            added = false;
            for (Pair pair2 : this.foodeffect) {
                if (pair.getSecond() != pair2.getSecond() || !SoupInfo.isEffectEquals((EffectInstance)pair2.getFirst(), (EffectInstance)pair.getFirst())) continue;
                ((EffectInstance)pair2.getFirst()).field_76460_b = (int)((float)((EffectInstance)pair2.getFirst()).field_76460_b + (float)((EffectInstance)pair.getFirst()).field_76460_b * oparts / cparts);
                added = true;
                break;
            }
            if (added) continue;
            this.foodeffect.add((Pair<EffectInstance, Float>)pair);
        }
        this.shrinkedFluid += f.shrinkedFluid * oparts / cparts;
        for (FloatemStack floatemStack : f.stacks) {
            this.addItem(new FloatemStack(floatemStack.getStack(), floatemStack.count * oparts / cparts));
        }
        this.completeAll();
        return true;
    }

    public void completeAll() {
        this.completeData();
        this.completeEffects();
    }

    public void completeData() {
        this.stacks.sort(Comparator.comparingInt(e -> Item.func_150891_b((Item)e.stack.func_77973_b())));
        this.foodeffect.sort(Comparator.comparingInt(e -> Effect.func_188409_a((Effect)((EffectInstance)e.getFirst()).func_188419_a())).thenComparing(Pair::getSecond));
    }

    public void completeEffects() {
        this.effects.sort(Comparator.comparingInt(x -> Effect.func_188409_a((Effect)x.func_188419_a())).thenComparingInt(e -> e.func_76459_b()));
    }

    public static boolean isEffectEquals(EffectInstance t1, EffectInstance t2) {
        return t1.func_188419_a() == t2.func_188419_a() && t1.func_76458_c() == t2.func_76458_c();
    }

    public void addEffect(EffectInstance eff, float parts) {
        for (EffectInstance oes : this.effects) {
            if (!SoupInfo.isEffectEquals(oes, eff)) continue;
            oes.field_76460_b = Math.max(oes.field_76460_b, (int)Math.min((float)oes.field_76460_b + (float)eff.field_76460_b / parts, (float)eff.field_76460_b * 2.0f));
            return;
        }
        if (this.effects.size() < 3) {
            EffectInstance copy = new EffectInstance(eff);
            copy.field_76460_b = (int)((float)copy.field_76460_b / parts);
            this.effects.add(copy);
        }
    }

    public void recalculateHAS() {
        this.foodeffect.clear();
        float nh = 0.0f;
        float ns = 0.0f;
        for (FloatemStack fs : this.stacks) {
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(fs.getItem());
            if (fvr != null) {
                nh += (float)fvr.heal * fs.count;
                ns += fvr.sat * (float)fvr.heal * fs.count;
                this.foodeffect.addAll(fvr.effects);
                continue;
            }
            Food f = fs.getItem().func_219967_s();
            if (f == null) continue;
            nh += fs.count * (float)f.func_221466_a();
            ns += fs.count * f.func_221469_b() * (float)f.func_221466_a();
            this.foodeffect.addAll(f.func_221464_f());
        }
        FluidFoodValueRecipe ffvr = FluidFoodValueRecipe.recipes.get(this.base);
        if (ffvr != null) {
            nh += (float)ffvr.heal * (1.0f + this.shrinkedFluid);
            ns += ffvr.sat * (1.0f + this.shrinkedFluid) / 2.0f;
        }
        float dense = this.getDensity();
        int conv = (int)((double)MathHelper.func_76131_a((float)((dense - 1.0f) / 2.0f), (float)0.0f, (float)1.0f) * 0.3 * (double)nh);
        this.healing = (int)Math.ceil(nh - (float)conv);
        this.saturation = this.healing > 0 ? Math.max(0.7f, (ns += (float)conv / 2.0f) / (float)this.healing) : 0.0f;
    }

    public void adjustParts(float oparts, float parts) {
        if (oparts == parts) {
            return;
        }
        for (FloatemStack fs : this.stacks) {
            fs.setCount(fs.getCount() * oparts / parts);
        }
        for (EffectInstance es : this.effects) {
            es.field_76460_b = (int)((float)es.field_76460_b * oparts / parts);
        }
        float delta = 0.0f;
        if (oparts > parts) {
            delta = oparts - parts;
        }
        this.shrinkedFluid = (this.shrinkedFluid * oparts + delta) / parts;
        this.healing = (int)((float)this.healing * oparts / parts);
        this.saturation = this.saturation * oparts / parts;
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        this.write(nbt);
        return nbt;
    }

    public SoupInfo(ResourceLocation base) {
        this(new ArrayList<FloatemStack>(), new ArrayList<EffectInstance>(), 0, 0.0f, base);
    }

    public static String getRegName(CompoundNBT nbt) {
        return nbt.func_74779_i("base");
    }

    public void addItem(ItemStack is, float parts) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is)) continue;
            i.count += (float)is.func_190916_E() / parts;
            return;
        }
        this.stacks.add(new FloatemStack(is.func_77946_l(), (float)is.func_190916_E() / parts));
    }

    public void addItem(FloatemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is.getStack())) continue;
            i.count += is.count;
            return;
        }
        this.stacks.add(is);
    }

    public void write(CompoundNBT nbt) {
        nbt.func_218657_a("items", (INBT)SerializeUtil.toNBTList(this.stacks, FloatemStack::serializeNBT));
        nbt.func_218657_a("effects", (INBT)SerializeUtil.toNBTList(this.effects, e -> e.func_82719_a(new CompoundNBT())));
        nbt.func_218657_a("feffects", (INBT)SerializeUtil.toNBTList(this.foodeffect, e -> {
            CompoundNBT cnbt = new CompoundNBT();
            cnbt.func_218657_a("effect", (INBT)((EffectInstance)e.getFirst()).func_82719_a(new CompoundNBT()));
            cnbt.func_74776_a("chance", ((Float)e.getSecond()).floatValue());
            return cnbt;
        }));
        nbt.func_74768_a("heal", this.healing);
        nbt.func_74776_a("sat", this.saturation);
        nbt.func_74778_a("base", this.base.toString());
        nbt.func_74776_a("afluid", this.shrinkedFluid);
    }
}

