/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin.pharaoh;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.entity.IPharaohData;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.util.PharaohUtil;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void betterdeserttemples_clearTempleOnPharaohDeath(class_1282 damageSource, CallbackInfo info) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (!PharaohUtil.isPharaoh((Object)this)) {
            return;
        }
        class_243 originalSpawnPos = ((IPharaohData)((Object)this)).getOriginalSpawnPos();
        if (originalSpawnPos == null) {
            BetterDesertTemplesCommon.LOGGER.error("Pharaoh entity is missing original spawn position data. Attempting to clear the temple it's inside of instead...");
            this.tryClearTempleAtPosition(serverLevel, this.method_24515(), damageSource);
        } else {
            class_2338 pharaohSpawnPos = new class_2338((int)originalSpawnPos.field_1352, (int)originalSpawnPos.field_1351, (int)originalSpawnPos.field_1350);
            this.tryClearTempleAtPosition(serverLevel, pharaohSpawnPos, damageSource);
        }
    }

    @Unique
    private void tryClearTempleAtPosition(class_3218 serverLevel, class_2338 pos, class_1282 damageSource) {
        class_3449 structureStart = serverLevel.method_27056().method_41413(pos, TagModule.APPLIES_MINING_FATIGUE);
        if (structureStart.method_16657()) {
            class_3222 killer;
            class_2338 structureStartPos = structureStart.method_34000().method_8323();
            ((ITempleStateCacheProvider)this.method_37908()).getTempleStateCache().setTempleCleared(structureStartPos, true);
            List<class_3222> playersInTemple = serverLevel.method_18456().stream().filter(player -> this.method_37908().method_8477(player.method_24515()) && serverLevel.method_27056().method_41413(player.method_24515(), TagModule.APPLIES_MINING_FATIGUE).method_16657()).toList();
            playersInTemple.forEach(player -> {
                player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)class_3417.field_19344), class_3419.field_15251, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, 1.0f, serverLevel.method_8412()));
                player.method_6016(class_1294.field_5901);
            });
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_3222 && !playersInTemple.contains(killer = (class_3222)class_12972)) {
                killer.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)class_3417.field_19344), class_3419.field_15251, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, 1.0f, serverLevel.method_8412()));
                killer.method_6016(class_1294.field_5901);
            }
            BetterDesertTemplesCommon.LOGGER.info("Cleared Better Desert Temple at x={}, z={}", (Object)structureStartPos.method_10263(), (Object)structureStartPos.method_10260());
        } else {
            BetterDesertTemplesCommon.LOGGER.error("Position provided is not inside a Better Desert Temple. Unable to clear temple.");
        }
    }
}

