/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin.pharaoh;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.entity.IPharaohData;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.util.PharaohUtil;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void betterdeserttemples_clearTempleOnPharaohDeath(DamageSource damageSource, CallbackInfo info) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!PharaohUtil.isPharaoh((Object)this)) {
            return;
        }
        Vec3 originalSpawnPos = ((IPharaohData)((Object)this)).getOriginalSpawnPos();
        if (originalSpawnPos == null) {
            BetterDesertTemplesCommon.LOGGER.error("Pharaoh entity is missing original spawn position data. Attempting to clear the temple it's inside of instead...");
            this.tryClearTempleAtPosition(serverLevel, this.m_20183_(), damageSource);
        } else {
            BlockPos pharaohSpawnPos = new BlockPos((int)originalSpawnPos.f_82479_, (int)originalSpawnPos.f_82480_, (int)originalSpawnPos.f_82481_);
            this.tryClearTempleAtPosition(serverLevel, pharaohSpawnPos, damageSource);
        }
    }

    @Unique
    private void tryClearTempleAtPosition(ServerLevel serverLevel, BlockPos pos, DamageSource damageSource) {
        StructureStart structureStart = serverLevel.m_215010_().m_220491_(pos, TagModule.APPLIES_MINING_FATIGUE);
        if (structureStart.m_73603_()) {
            ServerPlayer killer;
            BlockPos structureStartPos = structureStart.m_163625_().m_45615_();
            ((ITempleStateCacheProvider)this.m_9236_()).getTempleStateCache().setTempleCleared(structureStartPos, true);
            List<ServerPlayer> playersInTemple = serverLevel.m_6907_().stream().filter(player -> this.m_9236_().m_46749_(player.m_20183_()) && serverLevel.m_215010_().m_220491_(player.m_20183_(), TagModule.APPLIES_MINING_FATIGUE).m_73603_()).toList();
            playersInTemple.forEach(player -> {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11738_), SoundSource.HOSTILE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, 1.0f, serverLevel.m_7328_()));
                player.m_21195_(MobEffects.f_19599_);
            });
            Entity entity = damageSource.m_7639_();
            if (entity instanceof ServerPlayer && !playersInTemple.contains(killer = (ServerPlayer)entity)) {
                killer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11738_), SoundSource.HOSTILE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, 1.0f, serverLevel.m_7328_()));
                killer.m_21195_(MobEffects.f_19599_);
            }
            BetterDesertTemplesCommon.LOGGER.info("Cleared Better Desert Temple at x={}, z={}", (Object)structureStartPos.m_123341_(), (Object)structureStartPos.m_123343_());
        } else {
            BetterDesertTemplesCommon.LOGGER.error("Position provided is not inside a Better Desert Temple. Unable to clear temple.");
        }
    }
}

