/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin.pharaoh;

import com.yungnickyoung.minecraft.betterdeserttemples.entity.IPharaohData;
import com.yungnickyoung.minecraft.betterdeserttemples.util.PharaohUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Zombie.class})
public class ZombieMixin {
    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void betterdeserttemples_readPharaohOriginalSpawnPosFromNbt(CompoundTag compoundTag, CallbackInfo info) {
        if (PharaohUtil.isPharaoh(this)) {
            ListTag originalSpawnPos = compoundTag.m_128437_("bdtOriginalSpawnPos", 6);
            if (originalSpawnPos.size() != 3) {
                return;
            }
            double spawnX = originalSpawnPos.m_128772_(0);
            double spawnY = originalSpawnPos.m_128772_(1);
            double spawnZ = originalSpawnPos.m_128772_(2);
            ((IPharaohData)((Object)this)).setOriginalSpawnPos(new Vec3(spawnX, spawnY, spawnZ));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void betterdeserttemples_writePharaohOriginalSpawnPosToNbt(CompoundTag compoundTag, CallbackInfo info) {
        if (PharaohUtil.isPharaoh(this)) {
            Vec3 originalSpawnPos = ((IPharaohData)((Object)this)).getOriginalSpawnPos();
            if (originalSpawnPos == null) {
                return;
            }
            ListTag originalSpawnPosList = new ListTag();
            originalSpawnPosList.add((Object)DoubleTag.m_128500_((double)originalSpawnPos.f_82479_));
            originalSpawnPosList.add((Object)DoubleTag.m_128500_((double)originalSpawnPos.f_82480_));
            originalSpawnPosList.add((Object)DoubleTag.m_128500_((double)originalSpawnPos.f_82481_));
            compoundTag.m_128365_("bdtOriginalSpawnPos", (Tag)originalSpawnPosList);
        }
    }
}

