/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdeserttemples.mixin.accessor.ChunkGeneratorStructureStateAccessor;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructurePlacementTypeModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class BetterDesertTemplePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<BetterDesertTemplePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(rec$ -> ((BetterDesertTemplePlacement)((Object)((Object)((Object)rec$)))).locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((BetterDesertTemplePlacement)((Object)((Object)((Object)rec$)))).frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((BetterDesertTemplePlacement)((Object)((Object)((Object)rec$)))).frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(rec$ -> ((BetterDesertTemplePlacement)((Object)((Object)((Object)rec$)))).salt()), (App)StructurePlacement.ExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((BetterDesertTemplePlacement)((Object)((Object)((Object)rec$)))).exclusionZone()), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType)).apply((Applicative)instance, instance.stable(BetterDesertTemplePlacement::new)));

    public BetterDesertTemplePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        BiomeSource biomeSource = ((ChunkGeneratorStructureStateAccessor)chunkGeneratorStructureState).getBiomeSource();
        RandomState randomState = chunkGeneratorStructureState.randomState();
        long seed = chunkGeneratorStructureState.getLevelSeed();
        ChunkPos chunkPos = this.getPotentialStructureChunk(seed, chunkX, chunkZ);
        if (chunkPos.x == chunkX && chunkPos.z == chunkZ) {
            BlockPos structurePos = chunkPos.getMiddleBlockPosition(120);
            boolean isOceanOrRiverNear = biomeSource.findBiomeHorizontal(structurePos.getX(), structurePos.getY(), structurePos.getZ(), 48, 2, biomeHolder -> biomeHolder.is(BiomeTags.IS_RIVER) || biomeHolder.is(BiomeTags.IS_OCEAN), randomState.oreRandom().at(structurePos), true, randomState.sampler()) != null;
            return !isOceanOrRiverNear;
        }
        return false;
    }

    public StructurePlacementType<?> type() {
        return StructurePlacementTypeModule.BETTER_DESERT_TEMPLE_PLACEMENT;
    }
}

