/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import net.darkhax.enchdesc.client.TooltipHandler;
import net.darkhax.enchdesc.handler.ConfigurationHandler;
import net.darkhax.enchdesc.lib.Constants;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="enchdesc", name="Enchantment Descriptions", version="1.0.3", acceptedMinecraftVersions="[1.11.2]")
public class EnchantmentDescriptions {
    @Mod.Instance(value="enchdesc")
    public static EnchantmentDescriptions instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            Constants.LOG.warn("This is a client side mod. There is no benefit to installing it server side.");
        } else if (event.getSide().equals((Object)Side.CLIENT)) {
            ConfigurationHandler.initConfig(event.getSuggestedConfigurationFile());
            MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().equals((Object)Side.CLIENT) && ConfigurationHandler.exploreMode) {
            for (Enchantment enchant : Enchantment.field_185264_b) {
                if (!I18n.func_135052_a((String)TooltipHandler.getTranslationKey(enchant), (Object[])new Object[0]).startsWith("enchantment.")) continue;
                Constants.LOG.info(String.format("Undefined enchantment from %s %s", TooltipHandler.getModName(enchant), TooltipHandler.getTranslationKey(enchant)));
            }
        }
    }
}

