/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.client;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;

    @SubscribeEvent
    public void onTooltipDisplayed(ItemTooltipEvent event) {
        if (event.getItemStack() != null && event.getItemStack().func_77973_b() instanceof ItemEnchantedBook) {
            List tooltip = event.getToolTip();
            if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
                ItemEnchantedBook item = (ItemEnchantedBook)event.getItemStack().func_77973_b();
                List<Enchantment> enchants = this.getEnchantments(item, event.getItemStack());
                for (Enchantment enchant : enchants) {
                    tooltip.add(I18n.func_135052_a((String)"tooltip.enchdesc.name", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)enchant.func_77320_a(), (Object[])new Object[0]));
                    tooltip.add(this.getDescription(enchant));
                    tooltip.add(I18n.func_135052_a((String)"tooltip.enchdesc.addedby", (Object[])new Object[0]) + ": " + ChatFormatting.BLUE + TooltipHandler.getModName(enchant));
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.enchdesc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, keyBindSneak.getDisplayName(), ChatFormatting.GRAY}));
            }
        }
    }

    private String getDescription(Enchantment enchantment) {
        String key = TooltipHandler.getTranslationKey(enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.enchdesc.missing", (Object[])new Object[]{TooltipHandler.getModName(enchantment), key});
        }
        return description;
    }

    private List<Enchantment> getEnchantments(ItemEnchantedBook book, ItemStack stack) {
        NBTTagList enchTags = book.func_92110_g(stack);
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (enchTags != null) {
            for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                short id = enchTags.func_150305_b(index).func_74765_d("id");
                Enchantment enchant = Enchantment.func_185262_c((int)id);
                if (enchant == null) continue;
                enchantments.add(enchant);
            }
        }
        return enchantments;
    }

    public static String getModName(IForgeRegistryEntry.Impl<?> registerable) {
        if (registerable != null && registerable.getRegistryName() != null) {
            String modID = registerable.getRegistryName().func_110624_b();
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modID);
            return mod != null ? mod.getName() : modID;
        }
        return "NULL";
    }

    public static String getTranslationKey(Enchantment enchant) {
        if (enchant != null && enchant.getRegistryName() != null) {
            return String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a());
        }
        return "NULL";
    }
}

