/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchdesc")
public class EnchantmentDescriptions {
    public static final String MOD_ID = "enchdesc";
    private static final Logger LOG = LogManager.getLogger((String)"Enchantment Descriptions");

    public EnchantmentDescriptions() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onFMLLoadComplete);
            MinecraftForge.EVENT_BUS.addListener(this::onTooltipDisplayed);
        });
    }

    private void onFMLLoadComplete(FMLLoadCompleteEvent event) {
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS) {
            if (!I18n.func_135052_a((String)this.getTranslationKey(enchant), (Object[])new Object[0]).startsWith("enchantment.")) continue;
            LOG.info(String.format("Undefined enchantment from %s %s", this.getModName(enchant), this.getTranslationKey(enchant)));
        }
    }

    private void onTooltipDisplayed(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemEnchantedBook) {
            List tooltip = event.getToolTip();
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (InputMappings.func_197956_a((int)keyBindSneak.getKey().func_197937_c())) {
                List<Enchantment> enchants = this.getEnchantments(event.getItemStack());
                for (Enchantment enchant : enchants) {
                    tooltip.add(new TextComponentString(ChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.name", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)enchant.func_77320_a(), (Object[])new Object[0])));
                    tooltip.add(new TextComponentString(ChatFormatting.GRAY + this.getDescription(enchant)));
                    tooltip.add(new TextComponentString(ChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.addedby", (Object[])new Object[0]) + ": " + ChatFormatting.BLUE + this.getModName(enchant)));
                }
            } else {
                tooltip.add(new TextComponentString(ChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, I18n.func_135052_a((String)keyBindSneak.func_197982_m(), (Object[])new Object[0]), ChatFormatting.GRAY})));
            }
        }
    }

    private String getDescription(Enchantment enchantment) {
        String key = this.getTranslationKey(enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.enchdesc.missing", (Object[])new Object[]{this.getModName(enchantment), key});
        }
        return description;
    }

    private List<Enchantment> getEnchantments(ItemStack stack) {
        NBTTagList nbttaglist = ItemEnchantedBook.func_92110_g((ItemStack)stack);
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)nbttagcompound.func_74779_i("id")));
            if (enchantment == null) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    private String getModName(Enchantment registerable) {
        if (registerable != null && registerable.getRegistryName() != null) {
            String modID = registerable.getRegistryName().func_110624_b();
            ModContainer mod = ModList.get().getModContainerById(modID).orElse(null);
            return mod != null ? mod.getModInfo().getDisplayName() : modID;
        }
        return "NULL";
    }

    private String getTranslationKey(Enchantment enchant) {
        return enchant != null && enchant.getRegistryName() != null ? String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a()) : "NULL";
    }
}

