/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="enchdesc")
@Mod.EventBusSubscriber(modid="enchdesc", value={Dist.CLIENT})
public class EnchantmentDescriptions {
    public static final String MOD_ID = "enchdesc";

    @SubscribeEvent
    public static void onTooltipDisplayed(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof EnchantedBookItem) {
            List tooltip = event.getToolTip();
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)keyBindSneak.getKey().func_197937_c())) {
                List<Enchantment> enchants = EnchantmentDescriptions.getEnchantments(event.getItemStack());
                for (Enchantment enchant : enchants) {
                    tooltip.add(new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.name", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)enchant.func_77320_a(), (Object[])new Object[0])));
                    tooltip.add(new StringTextComponent(TextFormatting.GRAY + EnchantmentDescriptions.getDescription(enchant)));
                    tooltip.add(new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.addedby", (Object[])new Object[0]) + ": " + TextFormatting.BLUE + EnchantmentDescriptions.getModName(enchant)));
                }
            } else {
                tooltip.add(new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.activate", (Object[])new Object[]{TextFormatting.LIGHT_PURPLE, I18n.func_135052_a((String)keyBindSneak.func_197982_m(), (Object[])new Object[0]), TextFormatting.GRAY})));
            }
        }
    }

    private static String getDescription(Enchantment enchantment) {
        String key = EnchantmentDescriptions.getTranslationKey(enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.enchdesc.missing", (Object[])new Object[]{EnchantmentDescriptions.getModName(enchantment), key});
        }
        return description;
    }

    private static List<Enchantment> getEnchantments(ItemStack stack) {
        ListNBT nbttaglist = EnchantedBookItem.func_92110_g((ItemStack)stack);
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)nbttagcompound.func_74779_i("id")));
            if (enchantment == null) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    private static String getModName(IForgeRegistryEntry<?> registerable) {
        if (registerable != null && registerable.getRegistryName() != null) {
            String modID = registerable.getRegistryName().func_110624_b();
            ModContainer mod = ModList.get().getModContainerById(modID).orElse(null);
            return mod != null ? mod.getModInfo().getDisplayName() : modID;
        }
        return "NULL";
    }

    private static String getTranslationKey(Enchantment enchant) {
        return enchant != null && enchant.getRegistryName() != null ? String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a()) : "NULL";
    }
}

