/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockResolver;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockListResolver
implements IBlockResolver {
    private final Collection<Block> blocks;

    public BlockListResolver(Collection<Block> blocks) {
        this.blocks = Collections.unmodifiableCollection(blocks);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getTypeId().toString());
        JsonArray blockArray = new JsonArray();
        this.blocks.forEach(block -> blockArray.add(block.getRegistryName().toString()));
        jsonObject.add("blocks", (JsonElement)blockArray);
        return jsonObject;
    }

    @Override
    public Collection<Block> resolveBlocks() {
        return this.blocks;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.func_180714_a(this.getTypeId().toString());
        buffer.writeInt(this.blocks.size());
        for (Block block : this.blocks) {
            buffer.func_192572_a(block.getRegistryName());
        }
    }

    @Override
    public ResourceLocation getTypeId() {
        return BlockIngredient.TYPE_BLOCK_LIST;
    }

    public static BlockListResolver deserialize(JsonObject json) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        JsonArray array = json.get("blocks").getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement object = array.get(i);
            ResourceLocation id = new ResourceLocation(object.getAsString());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null) {
                throw new IllegalArgumentException("Failed to find block with ID " + id.toString());
            }
            blocks.add(block);
        }
        return new BlockListResolver(blocks);
    }

    public static BlockListResolver deserialize(PacketBuffer buffer) {
        int amount = buffer.readInt();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < amount; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null) {
                throw new IllegalArgumentException("Failed to find block with ID " + id.toString());
            }
            blocks.add(block);
        }
        return new BlockListResolver(blocks);
    }
}

