/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.internal.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.internal.command.ArgumentTypeHandOutput;
import net.darkhax.bookshelf.internal.network.PacketSetClipboard;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class CommandHand {
    public CommandHand(LiteralArgumentBuilder<CommandSource> root) {
        root.then(Commands.func_197057_a((String)"hand").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)new ArgumentTypeHandOutput()).executes(ctx -> this.hand((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"clipboard", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.hand((CommandContext<CommandSource>)ctx, true)))));
    }

    private int hand(CommandContext<CommandSource> context, boolean hasClipboard) throws CommandSyntaxException {
        OutputType type = (OutputType)((Object)context.getArgument("type", OutputType.class));
        boolean useClipboard = hasClipboard && BoolArgumentType.getBool(context, (String)"clipboard");
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String outputText = (String)type.converter.apply(player.func_184614_ca());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(outputText), true);
        if (useClipboard) {
            Bookshelf.NETWORK.sendToPlayer(player, new PacketSetClipboard(outputText));
        }
        return 0;
    }

    public static enum OutputType {
        STRING("string", stack -> stack.toString()),
        JSON("json", stack -> {
            JsonObject json = new JsonObject();
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)(stack.func_77942_o() ? NBTIngredient.Serializer.INSTANCE : VanillaIngredientSerializer.INSTANCE)).toString());
            json.addProperty("item", stack.func_77973_b().getRegistryName().toString());
            json.addProperty("count", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                json.addProperty("nbt", stack.func_77978_p().toString());
            }
            return json.toString();
        }),
        ID("id", stack -> stack.func_77973_b().getRegistryName().toString());

        private final String name;
        private final Function<ItemStack, String> converter;

        private OutputType(String name, Function<ItemStack, String> converter) {
            this.name = name;
            this.converter = converter;
        }
    }
}

