/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class CheckPower
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final int min;
    private final int max;

    public CheckPower(int minPower, int maxPower) {
        this.min = minPower;
        this.max = maxPower;
    }

    public boolean test(LootContext ctx) {
        BlockPos pos = (BlockPos)ctx.func_216031_c(LootParameters.field_216286_f);
        if (pos != null) {
            int power = ctx.func_202879_g().func_175687_A(pos);
            return this.min <= power && this.max >= power;
        }
        return false;
    }

    static class Serializer
    extends ILootCondition.AbstractSerializer<CheckPower> {
        Serializer() {
            super(new ResourceLocation("bookshelf", "check_redstone_power"), CheckPower.class);
        }

        public void serialize(JsonObject json, CheckPower value, JsonSerializationContext context) {
            json.addProperty("min", (Number)value.min);
            json.addProperty("max", (Number)value.max);
        }

        public CheckPower deserialize(JsonObject json, JsonDeserializationContext context) {
            int min = JSONUtils.func_151208_a((JsonObject)json, (String)"min", (int)1);
            int max = JSONUtils.func_151208_a((JsonObject)json, (String)"max", (int)15);
            return new CheckPower(min, max);
        }
    }
}

